package com.gameproject.soundstest;


import java.util.concurrent.ArrayBlockingQueue;

import com.gameproject.soundstest.GameView.GameLogic;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Bundle;
import android.util.Log;
import android.view.MotionEvent;
 
public class MainActivity extends Activity implements SensorEventListener{
    

    

	
	private SoundPool soundPool;
	
	private int ID_robot_noise;
	private int ID_alien_noise;
	private int ID_human_noise;
	
	GameView mGameView;
    private SensorManager mSensorManager;
    private Sensor mAccelerometer;
    private int sound_type;
	private ArrayBlockingQueue<InputObject> inputObjectPool;

	
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        mGameView = new GameView(this);
        setContentView(mGameView);
        mSensorManager = (SensorManager)getSystemService(SENSOR_SERVICE);
        mAccelerometer = mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        
		


    }
    
    
    
    protected void onResume() {
        super.onResume();
        mSensorManager.registerListener(this, mAccelerometer, SensorManager.SENSOR_DELAY_NORMAL);
    }

    protected void onPause() {
        super.onPause();
        mSensorManager.unregisterListener(this);
    }
    
    
	@Override
	public void onAccuracyChanged(Sensor arg0, int arg1) {
		// TODO W tym miejscu automatycznie generowany szkielet 
		
	}
	
	
	@Override
	public void onSensorChanged(SensorEvent event) {

		
		float R[] = new float[9];
		float orientation[] = new float[3];
		SensorManager.getOrientation(R, orientation);
		
		//Gamey.processOrientationEvent(orientation);
		
		//Log.d("azymut",Float.toString(orientation[0]));
		//Log.d("pochylenie",Float.toString(orientation[1]));
		//Log.d("przechylenie",Float.toString(orientation[2]));

	}
    
	
	@Override
	public boolean onTouchEvent(MotionEvent event) {
		return true;
			}

	
	

}

