package com.gameproject.harbordefender;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.Log;




public class SpriteObject {

	private Bitmap bitmap;
	private double x;		
	private double y;	
	private double x_move = 0;
	private double y_move = 0;
	
	public int DEAD = 0;
	public int ALIVE = 1;
	public int JUMPING = 2;
	public int CROUCHING = 3;
	private int state;
	private int health = 3;
	private int Orientation = -1;
	public int LEFT = 0;
	public int RIGHT = 1;
	public int UP = 2;
	public int DOWN = 3;
	private boolean stack = false;

	public SpriteObject(Bitmap bitmap, int x, int y) {
		this.bitmap = bitmap;
		this.x = x;
		this.y = y;
		state = ALIVE;
	}
	
	public int getState(){
		return state;
	}
	public void setState(int s){
		state = s;
	}

	public double getX() {
		return x;
	}
	
	public double getY() {
		return y;
	}
	
	public Bitmap getBitmap() {
		return bitmap;
	}
	public double getMoveY(){
		return y_move;
	}
	public double getMoveX(){
		return x_move;
	}

	
	
	public void setMoveX(double speedx){
		x_move = speedx;
	}
	
	public void setMoveY(double speedy){
		y_move = speedy;
	}
	
	public void setX(int x) {
		this.x = x;
	}

	public void setY(int y) {
		this.y = y;
	}
	public void setBitmap(Bitmap bitmap) {
		this.bitmap = bitmap;
	}
	
	
	

	public void draw(Canvas canvas) {
		if(state == ALIVE){
			Rect rec = new Rect((int)x,(int)y,(int)(x + bitmap.getWidth()),(int)(y + bitmap.getHeight()));
			canvas.drawBitmap(bitmap, null, rec, null);
		}
	}

	public void update(int adj_mov) {
		if(state == ALIVE){
			x += x_move;
			y += y_move;
			if(health <= 0){
				state = DEAD;
			}
		}
	}
	
	public boolean collide(SpriteObject entity){
		if(state != ALIVE){
			double left, entity_left;
			double right, entity_right;
			double top, entity_top;
			double bottom, entity_bottom;
	
			left = x;
			entity_left = entity.getX();
			right = x + bitmap.getWidth();
			entity_right = entity.getX() + entity.getBitmap().getWidth();
			top = y;
			entity_top = entity.getY();
			bottom = y + bitmap.getHeight();
			entity_bottom = entity.getY() + entity.getBitmap().getHeight();
	
			if (bottom < entity_top) {
				return false;
			}
			else if (top > entity_bottom){
				return false;
			}
			else if (right < entity_left) {
				return false;
			}
			else if (left > entity_right){
				return false;
			}
			else{
				return true;
			}
		}
		
		else{
			return false;
		}
		

	}

	public boolean cursor_selection(int cursor_x, int cursor_y){
		
		int sprite_right = (int)(getBitmap().getWidth() + getX());
		int sprite_bottom = (int)(getBitmap().getHeight() + getY());
		if(cursor_x > getX() && cursor_x < sprite_right && cursor_y > getY() && cursor_y < sprite_bottom){
			return true;
		}
		else{
			return false;
		}
		
	}
	
	public void setStacked(boolean s){
		stack = s;
	}
	public boolean getStacked(){
		return stack;
	}
	
	public void diminishHealth(int m){
		health -= m;
	}
	public int getHealth(){
		return health;
	}
	public void setOrientation(int o){
		Orientation = o;
	}
	public int getOrientation(){
		return Orientation;
	}

}
