package com.manning.aip.portfolio;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.PowerManager;

/**
 * Odbiornik {@link http://developer.android.com/reference/android/content/BroadcsatReceiver.html BraodcastReceiver} 
 * powiadamiany w momencie zgoszenia alertu systemowego. Odbiornik uruchamia usug 
 * {@link com.manning.aip.portfolio.PortfolioManagerService PortfolioManagerService} i przekazuje 
 * do niej blokad {@link http://developer.android.com/reference/android/os/PowerManager.WakeLock.html WakeLock}.
 * 
 * @author Michael Galpin
 *
 */
public class AlarmReceiver extends BroadcastReceiver {
	private static PowerManager.WakeLock wakeLock = null;
	private static final String LOCK_TAG = "com.manning.aip.portfolio";
	
	/**
	 * Metoda uywana do wspuytkowania blokady <code>WakeLock</code> utworzonej 
	 * przez odbiornik <code>BroadcastReceiver</code>. 
	 * Uwaga: metoda jest <code>synchroniczna</code>, poniewa tworzy blokad
	 * <code>WakeLock</code> w "leniwy" sposb.
	 * 
	 * @param 		ctx			Obiekt <code>Context</code> zajmujcy
	 * 							blokad.
	 */
	public static synchronized void acquireLock(Context ctx){
		if (wakeLock == null){
			PowerManager mgr = (PowerManager) ctx.getSystemService(Context.POWER_SERVICE);
			wakeLock = mgr.newWakeLock(PowerManager.PARTIAL_WAKE_LOCK, LOCK_TAG);
			wakeLock.setReferenceCounted(true);
		}
		wakeLock.acquire();
	}
	
	/**
	 * Metoda do zwalniania wspuytkowanej blokady <code>WakeLock</code>.
	 */
	public static synchronized void releaseLock(){
		if (wakeLock != null){
			wakeLock.release();
		}
	}
	
	/* (Niezgodne z Javadoc)
	 * @see android.content.BroadcastReceiver#onReceive(android.content.Context, android.content.Intent)
	 */
	@Override
	public void onReceive(Context context, Intent intent) {
		acquireLock(context);
		Intent stockService = 
			new Intent(context, PortfolioManagerService.class);
		context.startService(stockService);
	}

}
