/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.adb;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.monkeyrunner.MonkeyManager;
import com.android.monkeyrunner.adb.AdbMonkeyImage;
import com.android.monkeyrunner.adb.CommandOutputCapture;
import com.android.monkeyrunner.adb.LinearInterpolator;
import com.android.monkeyrunner.adb.LoggingOutputReceiver;
import com.android.monkeyrunner.core.IMonkeyDevice;
import com.android.monkeyrunner.core.IMonkeyImage;
import com.android.monkeyrunner.core.TouchPressType;
import com.android.monkeyrunner.easy.HierarchyViewer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdbMonkeyDevice
implements IMonkeyDevice {
    private static final Logger LOG = Logger.getLogger(AdbMonkeyDevice.class.getName());
    private static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final long MANAGER_CREATE_TIMEOUT_MS = 30000L;
    private static final long MANAGER_CREATE_WAIT_TIME_MS = 1000L;
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final IDevice device;
    private MonkeyManager manager;

    public AdbMonkeyDevice(IDevice device) {
        this.device = device;
        this.manager = this.createManager("127.0.0.1", 12345);
        Preconditions.checkNotNull((Object)this.manager);
    }

    @Override
    public MonkeyManager getManager() {
        return this.manager;
    }

    @Override
    public void dispose() {
        try {
            this.manager.quit();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error getting the manager to quit", e);
        }
        this.manager = null;
    }

    @Override
    public HierarchyViewer getHierarchyViewer() {
        return new HierarchyViewer(this.device);
    }

    private void executeAsyncCommand(final String command, final LoggingOutputReceiver logger) {
        this.executor.submit(new Runnable(){

            public void run() {
                try {
                    AdbMonkeyDevice.this.device.executeShellCommand(command, (IShellOutputReceiver)logger);
                }
                catch (TimeoutException e) {
                    LOG.log(Level.SEVERE, "Error starting command: " + command, e);
                    throw new RuntimeException(e);
                }
                catch (AdbCommandRejectedException e) {
                    LOG.log(Level.SEVERE, "Error starting command: " + command, e);
                    throw new RuntimeException(e);
                }
                catch (ShellCommandUnresponsiveException e) {
                    LOG.log(Level.INFO, "Error starting command: " + command, e);
                    throw new RuntimeException(e);
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Error starting command: " + command, e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private MonkeyManager createManager(String address, int port) {
        InetAddress addr;
        try {
            this.device.createForward(port, port);
        }
        catch (TimeoutException e) {
            LOG.log(Level.SEVERE, "Timeout creating adb port forwarding", e);
            return null;
        }
        catch (AdbCommandRejectedException e) {
            LOG.log(Level.SEVERE, "Adb rejected adb port forwarding command: " + e.getMessage(), e);
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to create adb port forwarding: " + e.getMessage(), e);
            return null;
        }
        String command = "monkey --port " + port;
        this.executeAsyncCommand(command, new LoggingOutputReceiver(LOG, Level.FINE));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Unable to sleep", e);
        }
        try {
            addr = InetAddress.getByName(address);
        }
        catch (UnknownHostException e) {
            LOG.log(Level.SEVERE, "Unable to convert address into InetAddress: " + address, e);
            return null;
        }
        boolean success = false;
        MonkeyManager mm = null;
        long start = System.currentTimeMillis();
        while (!success) {
            Socket monkeySocket;
            long now = System.currentTimeMillis();
            long diff = now - start;
            if (diff > 30000L) {
                LOG.severe("Timeout while trying to create monkey mananger");
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Unable to sleep", e);
            }
            try {
                monkeySocket = new Socket(addr, port);
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "Unable to connect socket", e);
                success = false;
                continue;
            }
            mm = new MonkeyManager(monkeySocket);
            try {
                mm.wake();
            }
            catch (IOException e) {
                LOG.log(Level.FINE, "Unable to wake up device", e);
                success = false;
                continue;
            }
            success = true;
        }
        return mm;
    }

    @Override
    public IMonkeyImage takeSnapshot() {
        try {
            return new AdbMonkeyImage(this.device.getScreenshot());
        }
        catch (TimeoutException e) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", e);
            return null;
        }
        catch (AdbCommandRejectedException e) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", e);
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", e);
            return null;
        }
    }

    @Override
    public String getSystemProperty(String key) {
        return this.device.getProperty(key);
    }

    @Override
    public String getProperty(String key) {
        try {
            return this.manager.getVariable(key);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to get variable: " + key, e);
            return null;
        }
    }

    @Override
    public void wake() {
        try {
            this.manager.wake();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to wake device (too sleepy?)", e);
        }
    }

    private String shell(String ... args) {
        StringBuilder cmd = new StringBuilder();
        for (String arg : args) {
            cmd.append(arg).append(" ");
        }
        return this.shell(cmd.toString());
    }

    @Override
    public String shell(String cmd) {
        CommandOutputCapture capture = new CommandOutputCapture();
        try {
            this.device.executeShellCommand(cmd, (IShellOutputReceiver)capture);
        }
        catch (TimeoutException e) {
            LOG.log(Level.SEVERE, "Error executing command: " + cmd, e);
            return null;
        }
        catch (ShellCommandUnresponsiveException e) {
            LOG.log(Level.SEVERE, "Error executing command: " + cmd, e);
            return null;
        }
        catch (AdbCommandRejectedException e) {
            LOG.log(Level.SEVERE, "Error executing command: " + cmd, e);
            return null;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error executing command: " + cmd, e);
            return null;
        }
        return capture.toString();
    }

    @Override
    public boolean installPackage(String path) {
        try {
            String result = this.device.installPackage(path, true);
            if (result != null) {
                LOG.log(Level.SEVERE, "Got error installing package: " + result);
                return false;
            }
            return true;
        }
        catch (InstallException e) {
            LOG.log(Level.SEVERE, "Error installing package: " + path, e);
            return false;
        }
    }

    @Override
    public boolean removePackage(String packageName) {
        try {
            String result = this.device.uninstallPackage(packageName);
            if (result != null) {
                LOG.log(Level.SEVERE, "Got error uninstalling package " + packageName + ": " + result);
                return false;
            }
            return true;
        }
        catch (InstallException e) {
            LOG.log(Level.SEVERE, "Error installing package: " + packageName, e);
            return false;
        }
    }

    @Override
    public void press(String keyName, TouchPressType type) {
        try {
            switch (type) {
                case DOWN_AND_UP: {
                    this.manager.press(keyName);
                    break;
                }
                case DOWN: {
                    this.manager.keyDown(keyName);
                    break;
                }
                case UP: {
                    this.manager.keyUp(keyName);
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error sending press event: " + keyName + " " + (Object)((Object)type), e);
        }
    }

    @Override
    public void type(String string) {
        try {
            this.manager.type(string);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error Typing: " + string, e);
        }
    }

    @Override
    public void touch(int x, int y, TouchPressType type) {
        try {
            switch (type) {
                case DOWN: {
                    this.manager.touchDown(x, y);
                    break;
                }
                case UP: {
                    this.manager.touchUp(x, y);
                    break;
                }
                case DOWN_AND_UP: {
                    this.manager.tap(x, y);
                }
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error sending touch event: " + x + " " + y + " " + (Object)((Object)type), e);
        }
    }

    @Override
    public void reboot(String into) {
        try {
            this.device.reboot(into);
        }
        catch (TimeoutException e) {
            LOG.log(Level.SEVERE, "Unable to reboot device", e);
        }
        catch (AdbCommandRejectedException e) {
            LOG.log(Level.SEVERE, "Unable to reboot device", e);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Unable to reboot device", e);
        }
    }

    @Override
    public void startActivity(String uri, String action, String data, String mimetype, Collection<String> categories, Map<String, Object> extras, String component, int flags) {
        List<String> intentArgs = this.buildIntentArgString(uri, action, data, mimetype, categories, extras, component, flags);
        this.shell(Lists.asList((Object)"am", (Object)"start", (Object[])intentArgs.toArray(ZERO_LENGTH_STRING_ARRAY)).toArray(ZERO_LENGTH_STRING_ARRAY));
    }

    @Override
    public void broadcastIntent(String uri, String action, String data, String mimetype, Collection<String> categories, Map<String, Object> extras, String component, int flags) {
        List<String> intentArgs = this.buildIntentArgString(uri, action, data, mimetype, categories, extras, component, flags);
        this.shell(Lists.asList((Object)"am", (Object)"broadcast", (Object[])intentArgs.toArray(ZERO_LENGTH_STRING_ARRAY)).toArray(ZERO_LENGTH_STRING_ARRAY));
    }

    private static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    private List<String> buildIntentArgString(String uri, String action, String data, String mimetype, Collection<String> categories, Map<String, Object> extras, String component, int flags) {
        ArrayList parts = Lists.newArrayList();
        if (!AdbMonkeyDevice.isNullOrEmpty(action)) {
            parts.add("-a");
            parts.add(action);
        }
        if (!AdbMonkeyDevice.isNullOrEmpty(data)) {
            parts.add("-d");
            parts.add(data);
        }
        if (!AdbMonkeyDevice.isNullOrEmpty(mimetype)) {
            parts.add("-t");
            parts.add(mimetype);
        }
        for (String string : categories) {
            parts.add("-c");
            parts.add(string);
        }
        for (Map.Entry entry : extras.entrySet()) {
            String arg;
            String valueString;
            Object value = entry.getValue();
            if (value instanceof Integer) {
                valueString = Integer.toString((Integer)value);
                arg = "--ei";
            } else if (value instanceof Boolean) {
                valueString = Boolean.toString((Boolean)value);
                arg = "--ez";
            } else {
                valueString = value.toString();
                arg = "--es";
            }
            parts.add(arg);
            parts.add(entry.getKey());
            parts.add(valueString);
        }
        if (!AdbMonkeyDevice.isNullOrEmpty(component)) {
            parts.add("-n");
            parts.add(component);
        }
        if (flags != 0) {
            parts.add("-f");
            parts.add(Integer.toString(flags));
        }
        if (!AdbMonkeyDevice.isNullOrEmpty(uri)) {
            parts.add(uri);
        }
        return parts;
    }

    @Override
    public Map<String, Object> instrument(String packageName, Map<String, Object> args) {
        ArrayList shellCmd = Lists.newArrayList((Object[])new String[]{"am", "instrument", "-w", "-r", packageName});
        String result = this.shell(shellCmd.toArray(ZERO_LENGTH_STRING_ARRAY));
        return AdbMonkeyDevice.convertInstrumentResult(result);
    }

    @VisibleForTesting
    static Map<String, Object> convertInstrumentResult(String result) {
        String value;
        String key;
        int splitIndex;
        String resultLine;
        HashMap map = Maps.newHashMap();
        Pattern pattern = Pattern.compile("^INSTRUMENTATION_(\\w+): ", 8);
        Matcher matcher = pattern.matcher(result);
        int previousEnd = 0;
        String previousWhich = null;
        while (matcher.find()) {
            if ("RESULT".equals(previousWhich)) {
                resultLine = result.substring(previousEnd, matcher.start()).trim();
                splitIndex = resultLine.indexOf("=");
                key = resultLine.substring(0, splitIndex);
                value = resultLine.substring(splitIndex + 1);
                map.put(key, value);
            }
            previousEnd = matcher.end();
            previousWhich = matcher.group(1);
        }
        if ("RESULT".equals(previousWhich)) {
            resultLine = result.substring(previousEnd, matcher.start()).trim();
            splitIndex = resultLine.indexOf("=");
            key = resultLine.substring(0, splitIndex);
            value = resultLine.substring(splitIndex + 1);
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void drag(int startx, int starty, int endx, int endy, int steps, long ms) {
        final long iterationTime = ms / (long)steps;
        LinearInterpolator lerp = new LinearInterpolator(steps);
        LinearInterpolator.Point start = new LinearInterpolator.Point(startx, starty);
        LinearInterpolator.Point end = new LinearInterpolator.Point(endx, endy);
        lerp.interpolate(start, end, new LinearInterpolator.Callback(){

            public void step(LinearInterpolator.Point point) {
                try {
                    AdbMonkeyDevice.this.manager.touchMove(point.getX(), point.getY());
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Error sending drag start event", e);
                }
                try {
                    Thread.sleep(iterationTime);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.SEVERE, "Error sleeping", e);
                }
            }

            public void start(LinearInterpolator.Point point) {
                try {
                    AdbMonkeyDevice.this.manager.touchDown(point.getX(), point.getY());
                    AdbMonkeyDevice.this.manager.touchMove(point.getX(), point.getY());
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Error sending drag start event", e);
                }
                try {
                    Thread.sleep(iterationTime);
                }
                catch (InterruptedException e) {
                    LOG.log(Level.SEVERE, "Error sleeping", e);
                }
            }

            public void end(LinearInterpolator.Point point) {
                try {
                    AdbMonkeyDevice.this.manager.touchMove(point.getX(), point.getY());
                    AdbMonkeyDevice.this.manager.touchUp(point.getX(), point.getY());
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Error sending drag end event", e);
                }
            }
        });
    }
}

