/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Sleeper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewFetcher {
    private final Instrumentation inst;
    private final ActivityUtils activityUtils;
    private final Sleeper sleeper;
    private static Class<?> windowManager;

    public ViewFetcher(Instrumentation inst, ActivityUtils activityUtils, Sleeper sleeper) {
        this.inst = inst;
        this.activityUtils = activityUtils;
        this.sleeper = sleeper;
    }

    public View getTopParent(View view) {
        if (view.getParent() != null && !view.getParent().getClass().getName().equals("android.view.ViewRoot")) {
            return this.getTopParent((View)view.getParent());
        }
        return view;
    }

    public View getListItemParent(View view) {
        if (view.getParent() != null && !(view.getParent() instanceof ListView)) {
            return this.getListItemParent((View)view.getParent());
        }
        return view;
    }

    public View getScrollOrListParent(View view) {
        if (!(view instanceof ListView) && !(view instanceof ScrollView)) {
            try {
                return this.getScrollOrListParent((View)view.getParent());
            }
            catch (Exception e) {
                return null;
            }
        }
        return view;
    }

    public ArrayList<View> getViewsFromDecorViews() {
        ArrayList<View> viewsInDecorViews;
        block10: {
            Activity activity = this.activityUtils.getCurrentActivity(false);
            View[] views = this.getWindowDecorViews();
            viewsInDecorViews = new ArrayList<View>();
            View[] nonDecorViews = this.getNonDecorViews(views);
            if (views == null || views.length <= 0) break block10;
            if (!activity.hasWindowFocus()) {
                for (View view : views) {
                    if (activity.getWindow().getDecorView().equals(view)) continue;
                    try {
                        this.addChildren(viewsInDecorViews, (ViewGroup)view);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
            } else {
                for (View view : nonDecorViews) {
                    try {
                        this.addChildren(viewsInDecorViews, (ViewGroup)view);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                try {
                    this.addChildren(viewsInDecorViews, (ViewGroup)this.getRecentDecorView(views));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        return viewsInDecorViews;
    }

    public final View getRecentDecorView(View[] views) {
        View[] decorViews = new View[views.length];
        int i = 0;
        for (View view : views) {
            if (!view.getClass().getName().equals("com.android.internal.policy.impl.PhoneWindow$DecorView")) continue;
            decorViews[i] = view;
            ++i;
        }
        return this.getRecentContainer(decorViews);
    }

    private final View getRecentContainer(View[] views) {
        View container = null;
        long drawingTime = 0L;
        for (View view : views) {
            if (view == null || !view.isShown() || view.getDrawingTime() <= drawingTime) continue;
            container = view;
            drawingTime = view.getDrawingTime();
        }
        return container;
    }

    private final View[] getNonDecorViews(View[] views) {
        View[] decorViews = new View[views.length];
        int i = 0;
        for (View view : views) {
            if (view.getClass().getName().equals("com.android.internal.policy.impl.PhoneWindow$DecorView")) continue;
            decorViews[i] = view;
            ++i;
        }
        return decorViews;
    }

    public View getView(int id) {
        Activity activity = this.activityUtils.getCurrentActivity(false);
        return activity.findViewById(id);
    }

    public ArrayList<View> getViews(View parent) {
        ArrayList<View> views = new ArrayList<View>();
        if (parent == null) {
            this.inst.waitForIdleSync();
            return this.getViewsFromDecorViews();
        }
        View parentToUse = parent;
        views.add(parentToUse);
        if (parentToUse instanceof ViewGroup) {
            this.addChildren(views, (ViewGroup)parentToUse);
        }
        return views;
    }

    private void addChildren(ArrayList<View> views, ViewGroup viewGroup) {
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View child = viewGroup.getChildAt(i);
            if (this.isViewFullyShown(child)) {
                views.add(child);
            }
            if (!(child instanceof ViewGroup)) continue;
            this.addChildren(views, (ViewGroup)child);
        }
    }

    public boolean isViewFullyShown(View view) {
        int[] xy = new int[2];
        int viewHeight = view.getHeight();
        view.getLocationOnScreen(xy);
        return !((float)(xy[1] + viewHeight) > this.getScrollListWindowHeight(view));
    }

    public float getScrollListWindowHeight(View view) {
        float windowHeight;
        int[] xyParent = new int[2];
        View parent = this.getScrollOrListParent(view);
        if (parent == null) {
            windowHeight = this.activityUtils.getCurrentActivity(false).getWindowManager().getDefaultDisplay().getHeight();
        } else {
            parent.getLocationOnScreen(xyParent);
            windowHeight = xyParent[1] + parent.getHeight();
        }
        return windowHeight;
    }

    public <T extends View> T getView(Class<T> classToFilterBy, int index) {
        this.sleeper.sleep();
        this.inst.waitForIdleSync();
        ArrayList<T> views = this.getCurrentViews(classToFilterBy);
        views = RobotiumUtils.removeInvisibleViews(views);
        View view = null;
        try {
            view = (View)views.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.assertTrue((String)("No " + classToFilterBy.getSimpleName() + " with index " + index + " is found!"), (boolean)false);
        }
        return (T)view;
    }

    public <T extends TextView> T getView(Class<T> classToFilterBy, String text) {
        this.sleeper.sleep();
        this.inst.waitForIdleSync();
        ArrayList<T> views = this.getCurrentViews(classToFilterBy);
        TextView viewToReturn = null;
        for (TextView view : views) {
            if (!((Object)view.getText()).toString().equals(text)) continue;
            viewToReturn = view;
        }
        if (viewToReturn == null) {
            Assert.assertTrue((String)("No " + classToFilterBy.getSimpleName() + " with text " + text + " is found!"), (boolean)false);
        }
        return (T)viewToReturn;
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy) {
        return this.getCurrentViews(classToFilterBy, null);
    }

    public <T extends View> ArrayList<T> getCurrentViews(Class<T> classToFilterBy, View parent) {
        ArrayList<T> filteredViews = new ArrayList<T>();
        ArrayList<View> allViews = this.getViews(parent);
        for (View view : allViews) {
            if (view == null || !classToFilterBy.isAssignableFrom(view.getClass())) continue;
            filteredViews.add(classToFilterBy.cast(view));
        }
        return filteredViews;
    }

    public View[] getWindowDecorViews() {
        try {
            Field viewsField = windowManager.getDeclaredField("mViews");
            Field instanceField = windowManager.getDeclaredField("mWindowManager");
            viewsField.setAccessible(true);
            instanceField.setAccessible(true);
            Object instance = instanceField.get(null);
            return (View[])viewsField.get(instance);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    static {
        try {
            windowManager = Class.forName("android.view.WindowManagerImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }
}

