/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.widget.EditText;
import com.jayway.android.robotium.solo.ActivityUtils;
import com.jayway.android.robotium.solo.Waiter;
import junit.framework.Assert;

class TextEnterer {
    private final ActivityUtils activityUtils;
    private final Waiter waiter;

    public TextEnterer(ActivityUtils activityUtils, Waiter waiter) {
        this.activityUtils = activityUtils;
        this.waiter = waiter;
    }

    public void setEditText(final EditText editText, final String text) {
        this.waiter.waitForView(EditText.class, 0);
        if (editText != null) {
            final String previousText = editText.getText().toString();
            if (!editText.isEnabled()) {
                Assert.assertTrue((String)"Edit text is not enabled!", (boolean)false);
            }
            this.activityUtils.getCurrentActivity(false).runOnUiThread(new Runnable(){

                public void run() {
                    editText.setInputType(0);
                    editText.performClick();
                    if (text.equals("")) {
                        editText.setText((CharSequence)text);
                    } else {
                        editText.setText((CharSequence)(previousText + text));
                        editText.setCursorVisible(false);
                    }
                }
            });
        }
    }
}

