/*
 * Decompiled with CFR 0.152.
 */
package com.android.monkeyrunner.easy;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.hierarchyviewerlib.device.DeviceBridge;
import com.android.hierarchyviewerlib.device.ViewNode;
import com.android.hierarchyviewerlib.device.Window;
import com.android.monkeyrunner.easy.By;
import org.eclipse.swt.graphics.Point;

public class HierarchyViewer {
    public static final String TAG = "hierarchyviewer";
    private IDevice mDevice;

    public HierarchyViewer(IDevice device) {
        this.mDevice = device;
        this.setupViewServer();
    }

    private void setupViewServer() {
        DeviceBridge.setupDeviceForward((IDevice)this.mDevice);
        if (!DeviceBridge.isViewServerRunning((IDevice)this.mDevice) && !DeviceBridge.startViewServer((IDevice)this.mDevice)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!DeviceBridge.startViewServer((IDevice)this.mDevice)) {
                Log.e((String)TAG, (String)("Unable to debug device " + this.mDevice));
                throw new RuntimeException("Could not connect to the view server");
            }
            return;
        }
        DeviceBridge.loadViewServerInfo((IDevice)this.mDevice);
    }

    public ViewNode findView(By selector) {
        ViewNode rootNode = DeviceBridge.loadWindowData((Window)new Window(this.mDevice, "", -1));
        if (rootNode == null) {
            throw new RuntimeException("Could not dump view");
        }
        return selector.find(rootNode);
    }

    public String getFocusedWindowName() {
        Window[] windows;
        int id = DeviceBridge.getFocusedWindow((IDevice)this.mDevice);
        for (Window w : windows = DeviceBridge.loadWindows((IDevice)this.mDevice)) {
            if (w.getHashCode() != id) continue;
            return w.getTitle();
        }
        return null;
    }

    public static Point getAbsolutePositionOfView(ViewNode node) {
        int x = node.left;
        int y = node.top;
        ViewNode p = node.parent;
        while (p != null) {
            x += p.left - p.scrollX;
            y += p.top - p.scrollY;
            p = p.parent;
        }
        return new Point(x, y);
    }

    public static Point getAbsoluteCenterOfView(ViewNode node) {
        Point point = HierarchyViewer.getAbsolutePositionOfView(node);
        return new Point(point.x + node.width / 2, point.y + node.height / 2);
    }

    public boolean visible(By selector) {
        ViewNode node = this.findView(selector);
        boolean ret = node != null && node.namedProperties.containsKey("getVisibility()") && "VISIBLE".equalsIgnoreCase(((ViewNode.Property)node.namedProperties.get((Object)"getVisibility()")).value);
        return ret;
    }

    public String getText(By selector) {
        ViewNode node = this.findView(selector);
        if (node == null) {
            throw new RuntimeException("Node not found");
        }
        ViewNode.Property textProperty = (ViewNode.Property)node.namedProperties.get("text:mText");
        if (textProperty == null) {
            throw new RuntimeException("No text property on node");
        }
        return textProperty.value;
    }
}

