/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.view.View;
import android.widget.TextView;
import com.jayway.android.robotium.solo.MatchCounter;
import com.jayway.android.robotium.solo.RobotiumUtils;
import com.jayway.android.robotium.solo.Scroller;
import com.jayway.android.robotium.solo.Searcher;
import com.jayway.android.robotium.solo.Sleeper;
import com.jayway.android.robotium.solo.ViewFetcher;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Waiter {
    private final ViewFetcher viewFetcher;
    private final int TIMEOUT = 20000;
    private final int SMALLTIMEOUT = 10000;
    private final int MINITIMEOUT = 300;
    private final Searcher searcher;
    private final Scroller scroller;
    private final Sleeper sleeper;

    public Waiter(ViewFetcher viewFetcher, Searcher searcher, Scroller scroller, Sleeper sleeper) {
        this.viewFetcher = viewFetcher;
        this.searcher = searcher;
        this.scroller = scroller;
        this.sleeper = sleeper;
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index) {
        return this.waitForView(viewClass, index, 10000, true);
    }

    public <T extends View> boolean waitForView(Class<T> viewClass, int index, int timeOut, boolean scroll) {
        ArrayList<Object> typeList = new ArrayList();
        long endTime = System.currentTimeMillis() + (long)timeOut;
        while (System.currentTimeMillis() < endTime) {
            this.sleeper.sleepMini();
            typeList = this.viewFetcher.getCurrentViews(viewClass);
            typeList = RobotiumUtils.removeInvisibleViews(typeList);
            MatchCounter.addMatchesToCount(typeList.size());
            typeList = null;
            if (MatchCounter.getTotalCount() > 0 && index < MatchCounter.getTotalCount()) {
                MatchCounter.resetCount();
                return true;
            }
            if (index == 0 && MatchCounter.getTotalCount() > 0) {
                MatchCounter.resetCount();
                return true;
            }
            if (scroll && !this.scroller.scroll(Scroller.Direction.DOWN)) {
                MatchCounter.resetCount();
            }
            if (scroll) continue;
            MatchCounter.resetCount();
        }
        MatchCounter.resetCount();
        return false;
    }

    public <T extends View> boolean waitForViews(Class<T> viewClass, Class<? extends View> viewClass2) {
        long endTime = System.currentTimeMillis() + 10000L;
        while (System.currentTimeMillis() < endTime) {
            if (this.waitForView(viewClass, 0, 300, true)) {
                return true;
            }
            if (!this.waitForView(viewClass2, 0, 300, true)) continue;
            return true;
        }
        return false;
    }

    public void waitForClickableItems() {
        this.sleeper.sleep();
        long startTime = System.currentTimeMillis();
        long timeout = 10000L;
        long endTime = startTime + timeout;
        while (System.currentTimeMillis() <= endTime && !this.clickableItemsExist()) {
            this.sleeper.sleep();
        }
    }

    private boolean clickableItemsExist() {
        ArrayList<View> clickableItems = new ArrayList<View>();
        clickableItems.addAll(this.viewFetcher.getViewsFromDecorViews());
        for (View view : clickableItems) {
            if (view.getTouchables().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean waitForText(String text) {
        return this.waitForText(text, 0, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, 20000L, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, true);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll) {
        return this.waitForText(text, expectedMinimumNumberOfMatches, timeout, scroll, false);
    }

    public boolean waitForText(String text, int expectedMinimumNumberOfMatches, long timeout, boolean scroll, boolean onlyVisible) {
        boolean foundAnyTextView;
        long endTime = System.currentTimeMillis() + timeout;
        do {
            boolean timedOut;
            boolean bl = timedOut = System.currentTimeMillis() > endTime;
            if (timedOut) {
                return false;
            }
            this.sleeper.sleep();
        } while (!(foundAnyTextView = this.searcher.searchFor(TextView.class, text, expectedMinimumNumberOfMatches, scroll, onlyVisible)));
        return true;
    }
}

