package com.marcodinacci.android.commons;

import android.util.Log;


/**
 * Oglna klasa do (prostego) przetwarzania grafiki. 
 * Nie jest podklas klasy Bitmap z android.graphics, ktra jest zadeklarowana jako final
 * 
 * TODO refaktoryzacja: utworzy rne klasy, po jednej dla kadego PixelFormat,
 * i zaimplementowa zdefiniowane teu abstrakcyjne operacje, zamiast uywa  
 * nieeleganckiej instrukcji switch-case
 * 
 */
public abstract class AbstractAndroidImage implements AndroidImage {
	
	private final String TAG = "AbstractAndroidImage"; //this.getClass().getName();
	protected byte[] mData;
	protected Size<Integer, Integer> mSize;

	public AbstractAndroidImage(byte[] data, Size<Integer, Integer> size) {
		mData = data;
		mSize = size;
	}

	// TODO zgasza wyjtki i rejestrowa napotkane bdy
	protected boolean assertImage(AndroidImage other) {
		boolean result = true;
		
		byte[] otherData = other.get();
		
		if(mData.length != otherData.length) {
			Log.e(TAG, "Dugo danych w porwnywanych obrazach jest rna");
			// Dugo danych musi by taka sama
			result = false;
		}
		/*
		if(other.getClass() == this.getClass()) {
			Log.e(TAG, "Nie mona porwna dwch odmiennych implementacji: " + 
					getClass().getName() + " and " + other.getClass().getName());
			result = false;
		}*/
		
		otherData = null;
		
		Log.d(TAG, "Rysunki s zgodne: " + result);
		
		return result;
	}
	
	/* 
	 * @see com.marcodinacci.android.commons.AndroidImage#toGrayScale()
	 */
	@Override
	public abstract AndroidImage toGrayscale();

	/* 
	 * @see com.marcodinacci.android.commons.AndroidImage#erode(int)
	 * TODO Doda implementacj. Zastosowa warto typu int 
	 * jako odlego w metryce Manhattan
	 */
	@Override
	public AndroidImage erode(int erosionLevel) {
		return this;
	}

	/* 
	 * @see com.marcodinacci.android.commons.AndroidImage#morph(byte[], int)
	 */
	@Override
	public AndroidImage morph(AndroidImage other, int value) {
		Log.v(TAG, "Rozpoczynanie przeksztace z wykorzystaniem wartoci: " + value);
		
		byte[] otherData = other.get();

		assert value <= 100 && value >= 0;
		
		if(value == 0) return this;
		
		float thisValue = (100 - value) / 100; 
		float otherValue = value / 100;
		
		for (int i = 0; i < mData.length; i++) {
			mData[i] = (byte) Math.round((mData[i] * thisValue) + (otherData[i] * otherValue));
		}
		
		return this;
	}
	
	@Override
	public byte[] get() {
		return mData;
	}
}
