package com.examples;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import android.app.Activity;
import android.os.Bundle;
import android.widget.ListView;

public class Main extends Activity {

	private List<Country> countryList= new ArrayList<Country>();
	
	/** Wywoywana, gdy aktywno tworzona jest po raz pierwszy */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		// Ustawianie widoku
		setContentView(R.layout.listview);
		setTitle("TestIconizedListView");

		// Tworzenie parsera pliku raw/countries.xml
		CountryParser countryParser = new CountryParser();
		InputStream inputStream = getResources().openRawResource(
				R.raw.countries);
		
		// Przetwarzanie strumienia wejciowego
		countryParser.parse(inputStream);

		// Pobieranie listy pastw
		List<Country> countryList = countryParser.getList();
		
		
		// Tworzenie niestandardowego adaptera ArrayAdapter
		CountryArrayAdapter adapter = new CountryArrayAdapter(
				getApplicationContext(), R.layout.country_listitem, countryList);
		
		// Pobieranie referencji do kontrolki ListView
		ListView lv = (ListView) this.findViewById(R.id.countryLV);
		
		// Ustawianie adaptera kontrolki ListView
		lv.setAdapter(adapter);
	}
}
