package com.example.emailandroid;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class Main extends Activity implements OnClickListener {
        private static final String TAG = "Main";
        private Button emailButton;

        /** Wywoywana, gdy aktywno jest uruchamiana po raz pierwszy */
        @Override
        public void onCreate(Bundle savedInstanceState)
            {
                super.onCreate(savedInstanceState);

                // Ustawianie warstwy widoku
                setContentView(R.layout.main);

                // Pobieranie referencji do przycisku E-mail
                this.emailButton = (Button) this.findViewById(R.id.emailButton);

                // Ustawianie odbiornika zdarzenia onClick
                this.emailButton.setOnClickListener(this);

            }

        @Override
        public void onClick(View view) {
            if (view == this.emailButton) {
                Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
                emailIntent.setType("text/html");
                emailIntent.putExtra(android.content.Intent.EXTRA_TITLE, "Nagwek");
                emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "Temat");

                // Pobieranie referencji do zapisanego na stae acucha znakw 
                // i przekazywanie jej do intencji
                emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, 
                    getString(R.string.my_text));
                startActivity(emailIntent);
            }
        }
}
