/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.title;

import android.graphics.Canvas;
import android.graphics.Paint;
import java.io.Serializable;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.RectangleEdge;
import net.droidsolutions.droidcharts.common.RectangleInsets;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.core.LegendItem;
import net.droidsolutions.droidcharts.core.LegendItemCollection;
import net.droidsolutions.droidcharts.core.LegendItemSource;
import net.droidsolutions.droidcharts.core.block.Arrangement;
import net.droidsolutions.droidcharts.core.block.Block;
import net.droidsolutions.droidcharts.core.block.BlockContainer;
import net.droidsolutions.droidcharts.core.block.BlockFrame;
import net.droidsolutions.droidcharts.core.block.BlockResult;
import net.droidsolutions.droidcharts.core.block.BorderArrangement;
import net.droidsolutions.droidcharts.core.block.CenterArrangement;
import net.droidsolutions.droidcharts.core.block.ColumnArrangement;
import net.droidsolutions.droidcharts.core.block.EntityBlockParams;
import net.droidsolutions.droidcharts.core.block.FlowArrangement;
import net.droidsolutions.droidcharts.core.block.LabelBlock;
import net.droidsolutions.droidcharts.core.block.RectangleConstraint;
import net.droidsolutions.droidcharts.core.entity.EntityCollection;
import net.droidsolutions.droidcharts.core.entity.StandardEntityCollection;
import net.droidsolutions.droidcharts.core.entity.TitleEntity;
import net.droidsolutions.droidcharts.core.title.LegendGraphic;
import net.droidsolutions.droidcharts.core.title.LegendItemBlockContainer;
import net.droidsolutions.droidcharts.core.title.Title;

public class LegendTitle
extends Title
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2644010518533854633L;
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 12);
    public static final Paint DEFAULT_ITEM_PAINT = new Paint(1);
    private LegendItemSource[] sources;
    private transient Paint backgroundPaint;
    private RectangleEdge legendItemGraphicEdge;
    private RectangleAnchor legendItemGraphicAnchor;
    private RectangleAnchor legendItemGraphicLocation;
    private RectangleInsets legendItemGraphicPadding;
    private Font itemFont;
    private transient Paint itemPaint;
    private RectangleInsets itemLabelPadding;
    private BlockContainer items;
    private Arrangement hLayout;
    private Arrangement vLayout;
    private BlockContainer wrapper;

    static {
        DEFAULT_ITEM_PAINT.setColor(-16777216);
    }

    public LegendTitle(LegendItemSource source) {
        this(source, new FlowArrangement(), new ColumnArrangement());
    }

    public LegendTitle(LegendItemSource source, Arrangement hLayout, Arrangement vLayout) {
        this.sources = new LegendItemSource[]{source};
        this.items = new BlockContainer(hLayout);
        this.hLayout = hLayout;
        this.vLayout = vLayout;
        this.backgroundPaint = null;
        this.legendItemGraphicEdge = RectangleEdge.LEFT;
        this.legendItemGraphicAnchor = RectangleAnchor.CENTER;
        this.legendItemGraphicLocation = RectangleAnchor.CENTER;
        this.legendItemGraphicPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = DEFAULT_ITEM_PAINT;
        this.itemLabelPadding = new RectangleInsets(2.0, 2.0, 2.0, 2.0);
    }

    public LegendItemSource[] getSources() {
        return this.sources;
    }

    public void setSources(LegendItemSource[] sources) {
        if (sources == null) {
            throw new IllegalArgumentException("Null 'sources' argument.");
        }
        this.sources = sources;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
    }

    public RectangleEdge getLegendItemGraphicEdge() {
        return this.legendItemGraphicEdge;
    }

    public void setLegendItemGraphicEdge(RectangleEdge edge) {
        if (edge == null) {
            throw new IllegalArgumentException("Null 'edge' argument.");
        }
        this.legendItemGraphicEdge = edge;
    }

    public RectangleAnchor getLegendItemGraphicAnchor() {
        return this.legendItemGraphicAnchor;
    }

    public void setLegendItemGraphicAnchor(RectangleAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' point.");
        }
        this.legendItemGraphicAnchor = anchor;
    }

    public RectangleAnchor getLegendItemGraphicLocation() {
        return this.legendItemGraphicLocation;
    }

    public void setLegendItemGraphicLocation(RectangleAnchor anchor) {
        this.legendItemGraphicLocation = anchor;
    }

    public RectangleInsets getLegendItemGraphicPadding() {
        return this.legendItemGraphicPadding;
    }

    public void setLegendItemGraphicPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.legendItemGraphicPadding = padding;
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.itemFont = font;
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.itemPaint = paint;
    }

    public RectangleInsets getItemLabelPadding() {
        return this.itemLabelPadding;
    }

    public void setItemLabelPadding(RectangleInsets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("Null 'padding' argument.");
        }
        this.itemLabelPadding = padding;
    }

    protected void fetchLegendItems() {
        this.items.clear();
        RectangleEdge p = this.getPosition();
        if (RectangleEdge.isTopOrBottom(p)) {
            this.items.setArrangement(this.hLayout);
        } else {
            this.items.setArrangement(this.vLayout);
        }
        int s = 0;
        while (s < this.sources.length) {
            LegendItemCollection legendItems = this.sources[s].getLegendItems();
            if (legendItems != null) {
                int i = 0;
                while (i < legendItems.getItemCount()) {
                    LegendItem item = legendItems.get(i);
                    Block block = this.createLegendItemBlock(item);
                    this.items.add(block);
                    ++i;
                }
            }
            ++s;
        }
    }

    protected Block createLegendItemBlock(LegendItem item) {
        Paint textPaint;
        BlockContainer result = null;
        LegendGraphic lg = new LegendGraphic(item.getShape(), item.getFillPaint());
        lg.setShapeFilled(item.isShapeFilled());
        lg.setLine(item.getLine());
        lg.setLineStroke(item.getLineStroke());
        lg.setLinePaint(item.getLinePaint());
        lg.setLineVisible(item.isLineVisible());
        lg.setShapeVisible(item.isShapeVisible());
        lg.setShapeOutlineVisible(item.isShapeOutlineVisible());
        lg.setOutlinePaint(item.getOutlinePaint());
        lg.setOutlineStroke(item.getOutlineStroke());
        lg.setPadding(this.legendItemGraphicPadding);
        LegendItemBlockContainer legendItem = new LegendItemBlockContainer((Arrangement)new BorderArrangement(), item.getDataset(), item.getSeriesKey());
        lg.setShapeAnchor(this.getLegendItemGraphicAnchor());
        lg.setShapeLocation(this.getLegendItemGraphicLocation());
        legendItem.add(lg, this.legendItemGraphicEdge);
        Font textFont = item.getLabelFont();
        if (textFont == null) {
            textFont = this.itemFont;
        }
        if ((textPaint = item.getLabelPaint()) == null) {
            textPaint = this.itemPaint;
        }
        LabelBlock labelBlock = new LabelBlock(item.getLabel(), textFont, textPaint);
        labelBlock.setPadding(this.itemLabelPadding);
        legendItem.add(labelBlock);
        legendItem.setToolTipText(item.getToolTipText());
        legendItem.setURLText(item.getURLText());
        result = new BlockContainer(new CenterArrangement());
        result.add(legendItem);
        return result;
    }

    public BlockContainer getItemContainer() {
        return this.items;
    }

    @Override
    public Size2D arrange(Canvas g2, RectangleConstraint constraint) {
        Size2D result = new Size2D();
        this.fetchLegendItems();
        if (this.items.isEmpty()) {
            return result;
        }
        BlockContainer container = this.wrapper;
        if (container == null) {
            container = this.items;
        }
        RectangleConstraint c = this.toContentConstraint(constraint);
        Size2D size = container.arrange(g2, c);
        result.height = this.calculateTotalHeight(size.height);
        result.width = this.calculateTotalWidth(size.width);
        return result;
    }

    @Override
    public void draw(Canvas g2, Rectangle2D area) {
        this.draw(g2, area, null);
    }

    @Override
    public Object draw(Canvas g2, Rectangle2D area, Object params) {
        EntityCollection ec;
        Object val;
        Rectangle2D target = (Rectangle2D)area.clone();
        Rectangle2D hotspot = (Rectangle2D)area.clone();
        StandardEntityCollection sec = null;
        if (params instanceof EntityBlockParams && ((EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
            sec.add(new TitleEntity((Shape)hotspot, this));
        }
        target = this.trimMargin(target);
        if (this.backgroundPaint != null) {
            this.backgroundPaint.setStyle(Paint.Style.FILL);
            g2.drawRect((float)target.getMinX(), (float)target.getMinY(), (float)target.getMaxX(), (float)target.getMaxY(), this.backgroundPaint);
        }
        BlockFrame border = this.getFrame();
        border.draw(g2, target);
        border.getInsets().trim(target);
        BlockContainer container = this.wrapper;
        if (container == null) {
            container = this.items;
        }
        if ((val = container.draw(g2, target = this.trimPadding(target), params)) instanceof BlockResult && (ec = ((BlockResult)val).getEntityCollection()) != null && sec != null) {
            sec.addAll(ec);
            ((BlockResult)val).setEntityCollection(sec);
        }
        return val;
    }

    public BlockContainer getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(BlockContainer wrapper) {
        this.wrapper = wrapper;
    }

    @Override
    public void draw(Canvas g2, Rectangle area) {
        this.draw(g2, area);
    }
}

