/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts.core.block;

import android.graphics.Canvas;
import android.graphics.Paint;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Point2D;
import net.droidsolutions.droidcharts.awt.Rectangle;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.awt.Shape;
import net.droidsolutions.droidcharts.common.RectangleAnchor;
import net.droidsolutions.droidcharts.common.Size2D;
import net.droidsolutions.droidcharts.core.block.AbstractBlock;
import net.droidsolutions.droidcharts.core.block.Block;
import net.droidsolutions.droidcharts.core.block.BlockResult;
import net.droidsolutions.droidcharts.core.block.EntityBlockParams;
import net.droidsolutions.droidcharts.core.block.RectangleConstraint;
import net.droidsolutions.droidcharts.core.entity.ChartEntity;
import net.droidsolutions.droidcharts.core.entity.StandardEntityCollection;
import net.droidsolutions.droidcharts.core.text.TextBlock;
import net.droidsolutions.droidcharts.core.text.TextBlockAnchor;
import net.droidsolutions.droidcharts.core.text.TextUtilities;

public class LabelBlock
extends AbstractBlock
implements Block {
    static final long serialVersionUID = 249626098864178017L;
    private String text;
    private TextBlock label;
    private Font font;
    private String toolTipText;
    private String urlText;
    public static final Paint DEFAULT_PAINT = new Paint(1);
    private transient Paint paint;
    private TextBlockAnchor contentAlignmentPoint;
    private RectangleAnchor textAnchor;

    static {
        DEFAULT_PAINT.setColor(-16777216);
    }

    public LabelBlock(String label) {
        this(label, new Font("SansSerif", 0, 10), DEFAULT_PAINT);
    }

    public LabelBlock(String text, Font font) {
        this(text, font, DEFAULT_PAINT);
    }

    public LabelBlock(String text, Font font, Paint paint) {
        this.text = text;
        this.paint = paint;
        this.label = TextUtilities.createTextBlock(text, font, this.paint);
        this.font = font;
        this.toolTipText = null;
        this.urlText = null;
        this.contentAlignmentPoint = TextBlockAnchor.CENTER;
        this.textAnchor = RectangleAnchor.CENTER;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.font = font;
        this.label = TextUtilities.createTextBlock(this.text, font, this.paint);
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.paint = paint;
        this.label = TextUtilities.createTextBlock(this.text, this.font, this.paint);
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String text) {
        this.urlText = text;
    }

    public TextBlockAnchor getContentAlignmentPoint() {
        return this.contentAlignmentPoint;
    }

    public void setContentAlignmentPoint(TextBlockAnchor anchor) {
        if (anchor == null) {
            throw new IllegalArgumentException("Null 'anchor' argument.");
        }
        this.contentAlignmentPoint = anchor;
    }

    public RectangleAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public void setTextAnchor(RectangleAnchor anchor) {
        this.textAnchor = anchor;
    }

    @Override
    public Size2D arrange(Canvas g2, RectangleConstraint constraint) {
        Size2D s = this.label.calculateDimensions(g2);
        return new Size2D(this.calculateTotalWidth(s.getWidth()), this.calculateTotalHeight(s.getHeight()));
    }

    public void draw(Canvas g2, Rectangle2D area) {
        this.draw(g2, area, null);
    }

    @Override
    public Object draw(Canvas g2, Rectangle2D area, Object params) {
        area = this.trimMargin(area);
        this.drawBorder(g2, area);
        area = this.trimBorder(area);
        area = this.trimPadding(area);
        EntityBlockParams ebp = null;
        StandardEntityCollection sec = null;
        Shape entityArea = null;
        if (params instanceof EntityBlockParams && (ebp = (EntityBlockParams)params).getGenerateEntities()) {
            sec = new StandardEntityCollection();
            entityArea = (Shape)area.clone();
        }
        this.paint.setTypeface(this.font.getTypeFace());
        this.paint.setTextSize((float)this.font.getSize());
        Point2D pt = RectangleAnchor.coordinates(area, this.textAnchor);
        this.label.draw(g2, (float)pt.getX(), (float)pt.getY(), this.contentAlignmentPoint, this.paint);
        BlockResult result = null;
        if (ebp != null && sec != null && (this.toolTipText != null || this.urlText != null)) {
            ChartEntity entity = new ChartEntity(entityArea, this.toolTipText, this.urlText);
            sec.add(entity);
            result = new BlockResult();
            result.setEntityCollection(sec);
        }
        return result;
    }

    @Override
    public void draw(Canvas g2, Rectangle area) {
        this.draw(g2, area);
    }
}

