/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import java.util.List;
import net.droidsolutions.droidcharts.awt.Font;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.data.DefaultPieDataset;
import net.droidsolutions.droidcharts.core.data.PieDataset;
import net.droidsolutions.droidcharts.core.plot.PiePlot;

public class PieChartExampleView
extends View {
    private Rect mRect = new Rect();
    private Handler mHandler = new Handler();

    public PieChartExampleView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        PieDataset dataset = PieChartExampleView.createDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.draw(canvas, new Rectangle2D.Double(0.0, 0.0, this.mRect.width(), this.mRect.height()));
        Paint p = new Paint();
        p.setColor(-65536);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PieChartExampleView.this.invalidate();
            }
        });
    }

    private static PieDataset createDataset() {
        DefaultPieDataset dataset = new DefaultPieDataset();
        dataset.setValue((Comparable)((Object)"One"), new Double(1.0));
        dataset.setValue((Comparable)((Object)"Two"), new Double(2.0));
        dataset.setValue((Comparable)((Object)"Three"), new Double(3.0));
        dataset.setValue((Comparable)((Object)"Four"), new Double(4.0));
        dataset.setValue((Comparable)((Object)"Five"), new Double(5.0));
        dataset.setValue((Comparable)((Object)"Six"), new Double(6.0));
        return dataset;
    }

    private JFreeChart createChart(PieDataset dataset) {
        JFreeChart chart = ChartFactory.createPieChart("Pie Chart Demo 1", dataset, true, true, false);
        PiePlot plot = (PiePlot)chart.getPlot();
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint dkGray = new Paint(1);
        dkGray.setColor(-12303292);
        Paint lightGray = new Paint(1);
        lightGray.setColor(-3355444);
        lightGray.setStrokeWidth(10.0f);
        plot.setLabelBackgroundPaint(lightGray);
        plot.setBackgroundPaint(dkGray);
        chart.setBackgroundPaint(dkGray);
        plot.setLabelFont(new Font("SansSerif", 1, 12));
        Resources res = this.getResources();
        int[] colors = new int[]{res.getColor(2130968576), res.getColor(2130968577), res.getColor(2130968578), res.getColor(2130968579), res.getColor(2130968580), res.getColor(2130968581), res.getColor(2130968582), res.getColor(2130968583)};
        int[] outlineColors = new int[]{res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584), res.getColor(2130968584)};
        PieRenderer renderer = new PieRenderer(colors, outlineColors, 3.0f);
        renderer.setColor(plot, dataset);
        return chart;
    }

    public static class PieRenderer {
        private int[] fillColor;
        private int[] outlineColor;
        private float outlineStroke;

        public PieRenderer(int[] color2, int[] outlineColor, float outlineStroke) {
            this.fillColor = color2;
            this.outlineColor = outlineColor;
            this.outlineStroke = outlineStroke;
        }

        public void setColor(PiePlot plot, PieDataset dataset) {
            List keys = dataset.getKeys();
            int i = 0;
            while (i < keys.size()) {
                int aInt = i % this.fillColor.length;
                Paint fillPaint = new Paint(1);
                fillPaint.setColor(this.fillColor[aInt]);
                plot.setSectionPaint((Comparable)keys.get(i), fillPaint);
                Paint outlinePaint = new Paint(1);
                outlinePaint.setColor(this.outlineColor[aInt]);
                plot.setSectionOutlinePaint((Comparable)keys.get(i), outlinePaint);
                plot.setSectionOutlineStroke((Comparable)keys.get(i), Float.valueOf(this.outlineStroke));
                ++i;
            }
        }
    }
}

