/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class SensorEventListenerProxy
implements SensorEventListener {
    private final SensorManager mSensorManager;
    private SensorEventListener mListener = null;

    public SensorEventListenerProxy(SensorManager pSensorManager) {
        this.mSensorManager = pSensorManager;
    }

    public boolean startListening(SensorEventListener pListener, int pSensorType, int pRate) {
        Sensor sensor = this.mSensorManager.getDefaultSensor(pSensorType);
        if (sensor == null) {
            return false;
        }
        this.mListener = pListener;
        return this.mSensorManager.registerListener((SensorEventListener)this, sensor, pRate);
    }

    public void stopListening() {
        this.mListener = null;
        this.mSensorManager.unregisterListener((SensorEventListener)this);
    }

    public void onAccuracyChanged(Sensor pSensor, int pAccuracy) {
        if (this.mListener != null) {
            this.mListener.onAccuracyChanged(pSensor, pAccuracy);
        }
    }

    public void onSensorChanged(SensorEvent pEvent) {
        if (this.mListener != null) {
            this.mListener.onSensorChanged(pEvent);
        }
    }
}

