/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Typeface;
import java.util.List;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float mScale;
    private float mTranslate;
    private PointF mCenter;
    protected static final int GRID_COLOR = Color.argb((int)75, (int)200, (int)200, (int)200);

    public XYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4) {
        int n5;
        Object object;
        int n6;
        int n7;
        int n8;
        XYMultipleSeriesRenderer.Orientation orientation;
        Paint paint = new Paint();
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int n9 = 30;
        if (this.mRenderer.isShowLegend()) {
            n9 = n4 / 5;
        }
        int n10 = n + 20;
        int n11 = n2 + 10;
        int n12 = n + n3;
        int n13 = n2 + n4 - n9;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint);
        if (paint.getTypeface() == null || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
        }
        if ((orientation = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            n12 -= n9;
            n13 += n9 - 20;
        }
        boolean bl = (n8 = orientation.getAngle()) == 90;
        this.mScale = (float)n4 / (float)n3;
        this.mTranslate = Math.abs(n3 - n4) / 2;
        if (this.mScale < 1.0f) {
            this.mTranslate *= -1.0f;
        }
        this.mCenter = new PointF((float)((n + n3) / 2), (float)((n2 + n4) / 2));
        if (bl) {
            this.transform(canvas, n8, false);
        }
        double d = this.mRenderer.getXAxisMin();
        double d2 = this.mRenderer.getXAxisMax();
        double d3 = this.mRenderer.getYAxisMin();
        double d4 = this.mRenderer.getYAxisMax();
        boolean bl2 = this.mRenderer.isMinXSet();
        boolean bl3 = this.mRenderer.isMaxXSet();
        boolean bl4 = this.mRenderer.isMinYSet();
        boolean bl5 = this.mRenderer.isMaxYSet();
        double d5 = 0.0;
        double d6 = 0.0;
        int n14 = this.mDataset.getSeriesCount();
        String[] stringArray = new String[n14];
        for (n7 = 0; n7 < n14; ++n7) {
            double d7;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n7);
            stringArray[n7] = xYSeries.getTitle();
            if (xYSeries.getItemCount() == 0) continue;
            if (!bl2) {
                d7 = xYSeries.getMinX();
                d = Math.min(d, d7);
            }
            if (!bl3) {
                d7 = xYSeries.getMaxX();
                d2 = Math.max(d2, d7);
            }
            if (!bl4) {
                d7 = xYSeries.getMinY();
                d3 = Math.min(d3, (double)((float)d7));
            }
            if (bl5) continue;
            d7 = xYSeries.getMaxY();
            d4 = Math.max(d4, (double)((float)d7));
        }
        if (d2 - d != 0.0) {
            d5 = (double)(n12 - n10) / (d2 - d);
        }
        if (d4 - d3 != 0.0) {
            d6 = (float)((double)(n13 - n11) / (d4 - d3));
        }
        n7 = 0;
        for (n6 = 0; n6 < n14; ++n6) {
            XYSeries xYSeries = this.mDataset.getSeriesAt(n6);
            if (xYSeries.getItemCount() == 0) continue;
            n7 = 1;
            object = this.mRenderer.getSeriesRendererAt(n6);
            int n15 = xYSeries.getItemCount();
            float[] fArray = null;
            n5 = n15;
            int n16 = n5 * 2;
            fArray = new float[n16];
            for (int i = 0; i < n16; i += 2) {
                int n17 = i / 2;
                fArray[i] = (float)((double)n10 + d5 * (xYSeries.getX(n17) - d));
                fArray[i + 1] = (float)((double)n13 - d6 * (xYSeries.getY(n17) - d3));
            }
            this.drawSeries(canvas, paint, fArray, (SimpleSeriesRenderer)object, Math.min((float)n13, (float)((double)n13 + d6 * d3)), n6);
            if (this.isRenderPoints((SimpleSeriesRenderer)object)) {
                ScatterChart scatterChart = new ScatterChart(this.mDataset, this.mRenderer);
                scatterChart.drawSeries(canvas, paint, fArray, (SimpleSeriesRenderer)object, 0.0f, n6);
            }
            paint.setTextSize(this.mRenderer.getChartValuesTextSize());
            if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                paint.setTextAlign(Paint.Align.CENTER);
            } else {
                paint.setTextAlign(Paint.Align.LEFT);
            }
            if (!this.mRenderer.isDisplayChartValues()) continue;
            this.drawChartValuesText(canvas, xYSeries, paint, fArray, n6);
        }
        n6 = this.mRenderer.isShowLabels() && n7 != 0 ? 1 : 0;
        boolean bl6 = this.mRenderer.isShowGrid();
        if (n6 != 0 || bl6) {
            object = MathHelper.getLabels(d, d2, this.mRenderer.getXLabels());
            List<Double> list = MathHelper.getLabels(d3, d4, this.mRenderer.getYLabels());
            if (n6 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(Paint.Align.CENTER);
            }
            this.drawXLabels((List<Double>)object, this.mRenderer.getXTextLabelLocations(), canvas, paint, n10, n11, n13, d5, d);
            int n18 = list.size();
            for (n5 = 0; n5 < n18; ++n5) {
                double d8 = list.get(n5);
                float f = (float)((double)n13 - d6 * (d8 - d3));
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (n6 != 0) {
                        paint.setColor(this.mRenderer.getLabelsColor());
                        canvas.drawLine((float)(n10 - 4), f, (float)n10, f, paint);
                        this.drawText(canvas, this.getLabel(d8), n10 - 2, f - 2.0f, paint, 0);
                    }
                    if (!bl6) continue;
                    paint.setColor(GRID_COLOR);
                    canvas.drawLine((float)n10, f, (float)n12, f, paint);
                    continue;
                }
                if (orientation != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                if (n6 != 0) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    canvas.drawLine((float)(n12 + 4), f, (float)n12, f, paint);
                    this.drawText(canvas, this.getLabel(d8), n12 + 10, f - 2.0f, paint, 0);
                }
                if (!bl6) continue;
                paint.setColor(GRID_COLOR);
                canvas.drawLine((float)n12, f, (float)n10, f, paint);
            }
            if (n6 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                paint.setTextSize(this.mRenderer.getAxisTitleTextSize());
                paint.setTextAlign(Paint.Align.CENTER);
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, n13 + 24, paint, 0);
                    this.drawText(canvas, this.mRenderer.getYTitle(), n + 10, n2 + n4 / 2, paint, -90);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), n + n3 / 2, n11 + 10, paint, 0);
                } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n + n3 / 2, n2 + n4 - 10, paint, -90);
                    this.drawText(canvas, this.mRenderer.getYTitle(), n12 + 20, n2 + n4 / 2, paint, 0);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), n + 14, n11 + n4 / 2, paint, 0);
                }
            }
        }
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, stringArray, n10, n12, n2, n3, n4, n9, paint);
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.transform(canvas, n8, true);
            this.drawLegend(canvas, this.mRenderer, stringArray, n10, n12, n2, n3, n4, n9, paint);
            this.transform(canvas, n8, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            canvas.drawLine((float)n10, (float)n13, (float)n12, (float)n13, paint);
            if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine((float)n10, (float)n11, (float)n10, (float)n13, paint);
            } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine((float)n12, (float)n11, (float)n12, (float)n13, paint);
            }
        }
        if (bl) {
            this.transform(canvas, n8, true);
        }
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, Paint paint, float[] fArray, int n) {
        for (int i = 0; i < fArray.length; i += 2) {
            this.drawText(canvas, this.getLabel(xYSeries.getY(i / 2)), fArray[i], fArray[i + 1] - 3.5f, paint, 0);
        }
    }

    protected void drawText(Canvas canvas, String string, float f, float f2, Paint paint, int n) {
        int n2 = -this.mRenderer.getOrientation().getAngle() + n;
        if (n2 != 0) {
            canvas.rotate((float)n2, f, f2);
        }
        canvas.drawText(string, f, f2, paint);
        if (n2 != 0) {
            canvas.rotate((float)(-n2), f, f2);
        }
    }

    private void transform(Canvas canvas, float f, boolean bl) {
        if (bl) {
            canvas.scale(1.0f / this.mScale, this.mScale);
            canvas.translate(this.mTranslate, -this.mTranslate);
            canvas.rotate(-f, this.mCenter.x, this.mCenter.y);
        } else {
            canvas.rotate(f, this.mCenter.x, this.mCenter.y);
            canvas.translate(-this.mTranslate, this.mTranslate);
            canvas.scale(this.mScale, 1.0f / this.mScale);
        }
    }

    protected String getLabel(double d) {
        String string = "";
        string = d == (double)Math.round(d) ? Math.round(d) + "" : d + "";
        return string;
    }

    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n, int n2, int n3, double d, double d2) {
        int n4 = list.size();
        boolean bl = this.mRenderer.isShowLabels();
        boolean bl2 = this.mRenderer.isShowGrid();
        for (int i = 0; i < n4; ++i) {
            double d3 = list.get(i);
            float f = (float)((double)n + d * (d3 - d2));
            if (bl) {
                paint.setColor(this.mRenderer.getLabelsColor());
                canvas.drawLine(f, (float)n3, f, (float)(n3 + 4), paint);
                this.drawText(canvas, this.getLabel(d3), f, n3 + 12, paint, 0);
            }
            if (!bl2) continue;
            paint.setColor(GRID_COLOR);
            canvas.drawLine(f, (float)n3, f, (float)n2, paint);
        }
        if (bl) {
            paint.setColor(this.mRenderer.getLabelsColor());
            for (Double d4 : doubleArray) {
                float f = (float)((double)n + d * (d4 - d2));
                canvas.drawLine(f, (float)n3, f, (float)(n3 + 4), paint);
                this.drawText(canvas, this.mRenderer.getXTextLabel(d4), f, n3 + 12, paint, 0);
            }
        }
    }

    public abstract void drawSeries(Canvas var1, Paint var2, float[] var3, SimpleSeriesRenderer var4, float var5, int var6);

    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return false;
    }
}

