/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.PointStyle;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class LineChart
extends XYChart {
    private static final int SHAPE_WIDTH = 30;

    public LineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, float[] fArray, SimpleSeriesRenderer simpleSeriesRenderer, float f, int n) {
        int n2 = fArray.length;
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        float f2 = paint.getStrokeWidth();
        paint.setStrokeWidth(xYSeriesRenderer.getLineWidth());
        if (xYSeriesRenderer.isFillBelowLine()) {
            paint.setColor(xYSeriesRenderer.getFillBelowLineColor());
            int n3 = fArray.length;
            float[] fArray2 = new float[n3 + 4];
            System.arraycopy(fArray, 0, fArray2, 0, n2);
            fArray2[0] = fArray[0] + 1.0f;
            fArray2[n2] = fArray2[n2 - 2];
            fArray2[n2 + 1] = f;
            fArray2[n2 + 2] = fArray2[0];
            fArray2[n2 + 3] = fArray2[n2 + 1];
            paint.setStyle(Paint.Style.FILL);
            this.drawPath(canvas, fArray2, paint, true);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.STROKE);
        this.drawPath(canvas, fArray, paint, false);
        paint.setStrokeWidth(f2);
    }

    @Override
    public int getLegendShapeWidth() {
        return 30;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        canvas.drawLine(f, f2, f + 30.0f, f2, paint);
    }

    @Override
    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return ((XYSeriesRenderer)simpleSeriesRenderer).getPointStyle() != PointStyle.POINT;
    }
}

