/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import org.achartengine.chart.AbstractChart;
import org.achartengine.model.MultipleCategorySeries;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.SimpleSeriesRenderer;

public class DoughnutChart
extends AbstractChart {
    private static final int SHAPE_WIDTH = 10;
    private MultipleCategorySeries mDataset;
    private DefaultRenderer mRenderer;
    private int mStep;

    public DoughnutChart(MultipleCategorySeries multipleCategorySeries, DefaultRenderer defaultRenderer) {
        this.mDataset = multipleCategorySeries;
        this.mRenderer = defaultRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n, int n2, int n3, int n4) {
        Paint paint = new Paint();
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.mRenderer.getLabelsTextSize());
        int n5 = 30;
        if (this.mRenderer.isShowLegend()) {
            n5 = n4 / 5;
        }
        int n6 = n + 15;
        int n7 = n2 + 5;
        int n8 = n + n3 - 5;
        int n9 = n2 + n4 - n5;
        this.drawBackground(this.mRenderer, canvas, n, n2, n3, n4, paint);
        this.mStep = 7;
        int n10 = this.mDataset.getCategoriesCount();
        int n11 = Math.min(Math.abs(n8 - n6), Math.abs(n9 - n7));
        double d = 0.35;
        double d2 = 0.2 / (double)n10;
        int n12 = (int)((double)n11 * d);
        int n13 = (n6 + n8) / 2;
        int n14 = (n9 + n7) / 2;
        float f = (float)n12 * 0.9f;
        float f2 = (float)n12 * 1.1f;
        String[] stringArray = new String[n10];
        for (int i = 0; i < n10; ++i) {
            int n15 = this.mDataset.getItemCount(i);
            double d3 = 0.0;
            String[] stringArray2 = new String[n15];
            for (int j = 0; j < n15; ++j) {
                d3 += this.mDataset.getValues(i)[j];
                stringArray2[j] = this.mDataset.getTitles(i)[j];
            }
            float f3 = 0.0f;
            RectF rectF = new RectF((float)(n13 - n12), (float)(n14 - n12), (float)(n13 + n12), (float)(n14 + n12));
            for (int j = 0; j < n15; ++j) {
                paint.setColor(this.mRenderer.getSeriesRendererAt(j).getColor());
                float f4 = (float)this.mDataset.getValues(i)[j];
                float f5 = (float)((double)f4 / d3 * 360.0);
                canvas.drawArc(rectF, f3, f5, true, paint);
                if (this.mRenderer.isShowLabels()) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    double d4 = Math.toRadians(90.0f - (f3 + f5 / 2.0f));
                    double d5 = Math.sin(d4);
                    double d6 = Math.cos(d4);
                    int n16 = Math.round((float)n13 + (float)((double)f * d5));
                    int n17 = Math.round((float)n14 + (float)((double)f * d6));
                    int n18 = Math.round((float)n13 + (float)((double)f2 * d5));
                    int n19 = Math.round((float)n14 + (float)((double)f2 * d6));
                    canvas.drawLine((float)n16, (float)n17, (float)n18, (float)n19, paint);
                    int n20 = 10;
                    paint.setTextAlign(Paint.Align.LEFT);
                    if (n16 > n18) {
                        n20 = -n20;
                        paint.setTextAlign(Paint.Align.RIGHT);
                    }
                    canvas.drawLine((float)n18, (float)n19, (float)(n18 + n20), (float)n19, paint);
                    canvas.drawText(this.mDataset.getTitles(i)[j], (float)(n18 + n20), (float)(n19 + 5), paint);
                }
                f3 += f5;
            }
            n12 = (int)((double)n12 - (double)n11 * d2);
            f = (float)((double)f - ((double)n11 * d2 - 2.0));
            if (this.mRenderer.getBackgroundColor() != 0) {
                paint.setColor(this.mRenderer.getBackgroundColor());
            } else {
                paint.setColor(-1);
            }
            paint.setStyle(Paint.Style.FILL);
            rectF = new RectF((float)(n13 - n12), (float)(n14 - n12), (float)(n13 + n12), (float)(n14 + n12));
            canvas.drawArc(rectF, 0.0f, 360.0f, true, paint);
            --n12;
            stringArray[i] = this.mDataset.getCategory(i);
        }
        this.drawLegend(canvas, this.mRenderer, stringArray, n6, n8, n2, n3, n4, n5, paint);
    }

    @Override
    public int getLegendShapeWidth() {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f, float f2, Paint paint) {
        --this.mStep;
        canvas.drawCircle(f + 10.0f - (float)this.mStep, f2, (float)this.mStep, paint);
    }
}

