/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.data.XYDataset;
import net.droidsolutions.droidcharts.core.data.xy.XYSeries;
import net.droidsolutions.droidcharts.core.data.xy.XYSeriesCollection;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.plot.XYPlot;
import net.droidsolutions.droidcharts.core.renderer.xy.XYLineAndShapeRenderer;

public class XYLineChartExampleView
extends View {
    private Rect mRect = new Rect();
    private Handler mHandler = new Handler();

    public XYLineChartExampleView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        XYDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.draw(canvas, new Rectangle2D.Double(0.0, 0.0, this.mRect.width(), this.mRect.height()));
        Paint p = new Paint();
        p.setColor(-65536);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                XYLineChartExampleView.this.invalidate();
            }
        });
    }

    private XYDataset createDataset() {
        XYSeries series1 = new XYSeries((Comparable)((Object)"First"));
        series1.add(1.0, 1.0);
        series1.add(2.0, 4.0);
        series1.add(3.0, 3.0);
        series1.add(4.0, 5.0);
        series1.add(5.0, 5.0);
        series1.add(6.0, 7.0);
        series1.add(7.0, 7.0);
        series1.add(8.0, 8.0);
        XYSeries series2 = new XYSeries((Comparable)((Object)"Second"));
        series2.add(1.0, 5.0);
        series2.add(2.0, 7.0);
        series2.add(3.0, 6.0);
        series2.add(4.0, 8.0);
        series2.add(5.0, 4.0);
        series2.add(6.0, 4.0);
        series2.add(7.0, 2.0);
        series2.add(8.0, 1.0);
        XYSeries series3 = new XYSeries((Comparable)((Object)"Third"));
        series3.add(3.0, 4.0);
        series3.add(4.0, 3.0);
        series3.add(5.0, 2.0);
        series3.add(6.0, 3.0);
        series3.add(7.0, 6.0);
        series3.add(8.0, 3.0);
        series3.add(9.0, 4.0);
        series3.add(10.0, 3.0);
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        dataset.addSeries(series2);
        dataset.addSeries(series3);
        return dataset;
    }

    private JFreeChart createChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYLineChart("Line Chart Demo 6", "X", "Y", dataset, PlotOrientation.VERTICAL, true, true, false);
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint dkGray = new Paint(1);
        dkGray.setColor(-12303292);
        Paint lightGray = new Paint(1);
        lightGray.setColor(-3355444);
        lightGray.setStrokeWidth(10.0f);
        chart.setBackgroundPaint(white);
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(dkGray);
        plot.setDomainGridlinePaint(lightGray);
        plot.setRangeGridlinePaint(lightGray);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        renderer.setSeriesLinesVisible(0, false);
        plot.setRenderer(renderer);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return chart;
    }
}

