/*
 * Decompiled with CFR 0.152.
 */
package net.droidsolutions.droidcharts;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.view.View;
import net.droidsolutions.droidcharts.awt.Rectangle2D;
import net.droidsolutions.droidcharts.core.ChartFactory;
import net.droidsolutions.droidcharts.core.JFreeChart;
import net.droidsolutions.droidcharts.core.axis.CategoryAxis;
import net.droidsolutions.droidcharts.core.axis.CategoryLabelPositions;
import net.droidsolutions.droidcharts.core.axis.NumberAxis;
import net.droidsolutions.droidcharts.core.data.CategoryDataset;
import net.droidsolutions.droidcharts.core.data.DefaultCategoryDataset;
import net.droidsolutions.droidcharts.core.plot.CategoryPlot;
import net.droidsolutions.droidcharts.core.plot.PlotOrientation;
import net.droidsolutions.droidcharts.core.renderer.BarRenderer;

public class BarChartCategoryExampletView
extends View {
    private Rect mRect = new Rect();
    private Handler mHandler = new Handler();

    public BarChartCategoryExampletView(Context context) {
        super(context);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.mRect);
        CategoryDataset dataset = this.createDataset();
        JFreeChart chart = this.createChart(dataset);
        chart.draw(canvas, new Rectangle2D.Double(0.0, 0.0, this.mRect.width(), this.mRect.height()));
        Paint p = new Paint();
        p.setColor(-65536);
    }

    public void repaint() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                BarChartCategoryExampletView.this.invalidate();
            }
        });
    }

    private CategoryDataset createDataset() {
        String series1 = "First";
        String series2 = "Second";
        String series3 = "Third";
        String category1 = "Category 1";
        String category2 = "Category 2";
        String category3 = "Category 3";
        String category4 = "Category 4";
        String category5 = "Category 5";
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        dataset.addValue(1.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 1"));
        dataset.addValue(4.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 2"));
        dataset.addValue(3.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 3"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 4"));
        dataset.addValue(5.0, (Comparable)((Object)"First"), (Comparable)((Object)"Category 5"));
        dataset.addValue(5.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 1"));
        dataset.addValue(7.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 2"));
        dataset.addValue(6.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 3"));
        dataset.addValue(8.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 4"));
        dataset.addValue(4.0, (Comparable)((Object)"Second"), (Comparable)((Object)"Category 5"));
        dataset.addValue(4.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 1"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 2"));
        dataset.addValue(2.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 3"));
        dataset.addValue(3.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 4"));
        dataset.addValue(6.0, (Comparable)((Object)"Third"), (Comparable)((Object)"Category 5"));
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) {
        JFreeChart chart = ChartFactory.createBarChart("Bar Chart Demo", "Category", "Value", dataset, PlotOrientation.VERTICAL, true, true, false);
        Paint white = new Paint(1);
        white.setColor(-1);
        Paint dkGray = new Paint(1);
        dkGray.setColor(-12303292);
        Paint lightGray = new Paint(1);
        lightGray.setColor(-3355444);
        lightGray.setStrokeWidth(10.0f);
        Paint black = new Paint(1);
        black.setColor(-16777216);
        Paint borderPaint = new Paint(1);
        borderPaint.setColor(-1);
        borderPaint.setStrokeWidth(5.0f);
        chart.setBorderPaint(borderPaint);
        chart.setBackgroundPaint(dkGray);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setBackgroundPaint(dkGray);
        plot.setDomainGridlinePaint(lightGray);
        plot.setRangeGridlinePaint(lightGray);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        rangeAxis.setLabelAngle(90.0);
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        Paint blue = new Paint(1);
        blue.setColor(Color.rgb((int)125, (int)138, (int)46));
        blue.setAlpha(200);
        blue.setStrokeWidth(10.0f);
        Paint green = new Paint(1);
        green.setColor(Color.rgb((int)255, (int)240, (int)165));
        green.setAlpha(200);
        Paint red = new Paint(1);
        red.setColor(Color.rgb((int)182, (int)73, (int)38));
        red.setAlpha(200);
        renderer.setSeriesPaint(0, blue);
        renderer.setSeriesPaint(1, green);
        renderer.setSeriesPaint(2, red);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        return chart;
    }
}

