/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.linkedinapi.client.impl;

import com.google.code.linkedinapi.client.AsyncHandlerLinkedInApiClient;
import com.google.code.linkedinapi.client.AsyncResponseHandler;
import com.google.code.linkedinapi.client.LinkedInApiClient;
import com.google.code.linkedinapi.client.enumeration.NetworkUpdateType;
import com.google.code.linkedinapi.client.enumeration.ProfileField;
import com.google.code.linkedinapi.client.enumeration.ProfileType;
import com.google.code.linkedinapi.client.enumeration.SearchParameter;
import com.google.code.linkedinapi.client.enumeration.SearchSortOrder;
import com.google.code.linkedinapi.client.oauth.LinkedInAccessToken;
import com.google.code.linkedinapi.client.oauth.LinkedInApiConsumer;
import com.google.code.linkedinapi.schema.ApiStandardProfileRequest;
import com.google.code.linkedinapi.schema.Connections;
import com.google.code.linkedinapi.schema.Network;
import com.google.code.linkedinapi.schema.People;
import com.google.code.linkedinapi.schema.Person;
import com.google.code.linkedinapi.schema.UpdateComments;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class AsyncHandlerLinkedInApiClientAdapter
implements AsyncHandlerLinkedInApiClient {
    private LinkedInApiClient client;
    private ExecutorService taskExecutor;

    public AsyncHandlerLinkedInApiClientAdapter(LinkedInApiClient client, ExecutorService taskExecutor) {
        this.client = client;
        this.taskExecutor = taskExecutor;
    }

    protected Future execute(Runnable task) {
        return this.taskExecutor.submit(task);
    }

    protected <T> Future<T> execute(Callable<T> task) {
        return this.taskExecutor.submit(task);
    }

    @Override
    public void getConnectionsById(final String id, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsById(id);
            }
        }));
    }

    @Override
    public void getConnectionsById(final String id, final Set<ProfileField> profileFields, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsById(id, profileFields);
            }
        }));
    }

    @Override
    public void getConnectionsByUrl(final String url, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsByUrl(url);
            }
        }));
    }

    @Override
    public void getConnectionsByUrl(final String url, final Set<ProfileField> profileFields, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsByUrl(url, profileFields);
            }
        }));
    }

    @Override
    public void getConnectionsForCurrentUser(AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsForCurrentUser();
            }
        }));
    }

    @Override
    public void getConnectionsForCurrentUser(final Set<ProfileField> profileFields, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsForCurrentUser(profileFields);
            }
        }));
    }

    @Override
    public void getConnectionsById(final String id, final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsById(id, start, count);
            }
        }));
    }

    @Override
    public void getConnectionsById(final String id, final Set<ProfileField> profileFields, final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsById(id, (Set<ProfileField>)profileFields, start, count);
            }
        }));
    }

    @Override
    public void getConnectionsByUrl(final String url, final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsByUrl(url, start, count);
            }
        }));
    }

    @Override
    public void getConnectionsByUrl(final String url, final Set<ProfileField> profileFields, final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsByUrl(url, (Set<ProfileField>)profileFields, start, count);
            }
        }));
    }

    @Override
    public void getConnectionsForCurrentUser(final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsForCurrentUser(start, count);
            }
        }));
    }

    @Override
    public void getConnectionsForCurrentUser(final Set<ProfileField> profileFields, final int start, final int count, AsyncResponseHandler<Connections> handler) {
        handler.setFuture(this.execute(new Callable<Connections>(){

            @Override
            public Connections call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getConnectionsForCurrentUser((Set<ProfileField>)profileFields, start, count);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates();
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final int start, final int count, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates(start, count);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final Date startDate, final Date endDate, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates(startDate, endDate);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final Set<NetworkUpdateType> updateTypes, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates(updateTypes);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final Set<NetworkUpdateType> updateTypes, final int start, final int count, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates((Set<NetworkUpdateType>)updateTypes, start, count);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final Set<NetworkUpdateType> updateTypes, final Date startDate, final Date endDate, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates((Set<NetworkUpdateType>)updateTypes, startDate, endDate);
            }
        }));
    }

    @Override
    public void getNetworkUpdates(final Set<NetworkUpdateType> updateTypes, final int start, final int count, final Date startDate, final Date endDate, AsyncResponseHandler<Network> handler) {
        handler.setFuture(this.execute(new Callable<Network>(){

            @Override
            public Network call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdates(updateTypes, start, count, startDate, endDate);
            }
        }));
    }

    @Override
    public void getNetworkUpdateComments(final String networkUpdateId, AsyncResponseHandler<UpdateComments> handler) {
        handler.setFuture(this.execute(new Callable<UpdateComments>(){

            @Override
            public UpdateComments call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getNetworkUpdateComments(networkUpdateId);
            }
        }));
    }

    @Override
    public void getProfileById(final String id, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileById(id);
            }
        }));
    }

    @Override
    public void getProfileById(final String id, final Set<ProfileField> profileFields, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileById(id, profileFields);
            }
        }));
    }

    @Override
    public void getProfileByUrl(final String url, final ProfileType profileType, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileByUrl(url, profileType);
            }
        }));
    }

    @Override
    public void getProfileByUrl(final String url, final ProfileType profileType, final Set<ProfileField> profileFields, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileByUrl(url, profileType, profileFields);
            }
        }));
    }

    @Override
    public void getProfileByApiRequest(final ApiStandardProfileRequest apiRequest, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileByApiRequest(apiRequest);
            }
        }));
    }

    @Override
    public void getProfileForCurrentUser(AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileForCurrentUser();
            }
        }));
    }

    @Override
    public void getProfileForCurrentUser(final Set<ProfileField> profileFields, AsyncResponseHandler<Person> handler) {
        handler.setFuture(this.execute(new Callable<Person>(){

            @Override
            public Person call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.getProfileForCurrentUser(profileFields);
            }
        }));
    }

    @Override
    public void postComment(final String networkUpdateId, final String commentText, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.postComment(networkUpdateId, commentText);
            }
        }));
    }

    @Override
    public void postNetworkUpdate(final String updateText, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.postNetworkUpdate(updateText);
            }
        }));
    }

    @Override
    public void searchPeople(AsyncResponseHandler<People> handler) {
        handler.setFuture(this.execute(new Callable<People>(){

            @Override
            public People call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.searchPeople();
            }
        }));
    }

    @Override
    public void searchPeople(final Map<SearchParameter, String> searchParameters, AsyncResponseHandler<People> handler) {
        handler.setFuture(this.execute(new Callable<People>(){

            @Override
            public People call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.searchPeople(searchParameters);
            }
        }));
    }

    @Override
    public void searchPeople(final Map<SearchParameter, String> searchParameters, final int start, final int count, AsyncResponseHandler<People> handler) {
        handler.setFuture(this.execute(new Callable<People>(){

            @Override
            public People call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.searchPeople((Map<SearchParameter, String>)searchParameters, start, count);
            }
        }));
    }

    @Override
    public void searchPeople(final Map<SearchParameter, String> searchParameters, final SearchSortOrder sortOrder, AsyncResponseHandler<People> handler) {
        handler.setFuture(this.execute(new Callable<People>(){

            @Override
            public People call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.searchPeople((Map<SearchParameter, String>)searchParameters, sortOrder);
            }
        }));
    }

    @Override
    public void searchPeople(final Map<SearchParameter, String> searchParameters, final int start, final int count, final SearchSortOrder sortOrder, AsyncResponseHandler<People> handler) {
        handler.setFuture(this.execute(new Callable<People>(){

            @Override
            public People call() throws Exception {
                return AsyncHandlerLinkedInApiClientAdapter.this.client.searchPeople((Map<SearchParameter, String>)searchParameters, start, count, sortOrder);
            }
        }));
    }

    @Override
    public void sendInviteByEmail(final String email, final String firstName, final String lastName, final String subject, final String message, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.sendInviteByEmail(email, firstName, lastName, subject, message);
            }
        }));
    }

    @Override
    public void sendInviteToPerson(final Person recepient, final String subject, final String message, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.sendInviteToPerson(recepient, subject, message);
            }
        }));
    }

    @Override
    public void sendInviteById(final String recepientId, final String subject, final String message, final String authHeader, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.sendInviteById(recepientId, subject, message, authHeader);
            }
        }));
    }

    @Override
    public void sendMessage(final List<String> recepientIds, final String subject, final String message, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.sendMessage(recepientIds, subject, message);
            }
        }));
    }

    @Override
    public void updateCurrentStatus(final String status, AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.updateCurrentStatus(status);
            }
        }));
    }

    @Override
    public void deleteCurrentStatus(AsyncResponseHandler<?> handler) {
        handler.setFuture(this.execute(new Runnable(){

            @Override
            public void run() {
                AsyncHandlerLinkedInApiClientAdapter.this.client.deleteCurrentStatus();
            }
        }));
    }

    @Override
    public LinkedInAccessToken getAccessToken() {
        return this.client.getAccessToken();
    }

    @Override
    public LinkedInApiConsumer getApiConsumer() {
        return this.client.getApiConsumer();
    }

    @Override
    public void setAccessToken(LinkedInAccessToken accessToken) {
        this.client.setAccessToken(accessToken);
    }

    @Override
    public void setApiConsumer(LinkedInApiConsumer apiConsumer) {
        this.client.setApiConsumer(apiConsumer);
    }

    @Override
    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.client.setRequestHeaders(requestHeaders);
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        return this.client.getRequestHeaders();
    }

    @Override
    public void addRequestHeader(String headerName, String headerValue) {
        this.client.addRequestHeader(headerName, headerValue);
    }

    @Override
    public void removeRequestHeader(String headerName) {
        this.client.removeRequestHeader(headerName);
    }

    @Override
    public void addLocale(Locale locale) {
        this.client.addLocale(locale);
    }
}

