
private static const SOURCE:String = "http://ia600408.us.archive.org/"+
  "26/items/BigBuckBunny_328/BigBuckBunny_512kb.mp4";

private var video:Video;
private var ns:NetStream;
private var timer:Timer;
private var duration:String = "";

private function onInitialize():void {
  video = new Video();
  videoContainer.addChild(video);
  
  var nc:NetConnection = new NetConnection();
  nc.connect(null);
  
  ns = new NetStream(nc);
  ns.addEventListener(NetStatusEvent.NET_STATUS, onNetStatus);
  ns.client = {
    onMetaData: onMetaData, 
    onCuePoint: onCuePoint, 
    onPlayStatus: onPlayStatus
  };
  
  ns.play(SOURCE);
  video.attachNetStream(ns);
  
  timer = new Timer(1000);
  timer.addEventListener(TimerEvent.TIMER, onTimer);
  timer.start();
}

private function onViewDeactivate():void {
  if (ns) {
    ns.close();
  }
}

private function onMetaData(item:Object):void {
  video.width = item.width;
  video.height = item.height;
  
  video.x = (width - video.width) / 2;
  video.y = (height - video.height) / 2;
  
  if (item.duration)
    duration = formatSeconds(item.duration);
}

private function onCuePoint(item:Object):void {
  // Obiekt item ma cztery waciwoci: name, time, parameters, type
  log("punkt kontrolny "+item.name+" osignity");
}

private function onPlayStatus(item:Object):void {
  if (item.code == "NetStream.Play.Complete") {
    timer.stop();
    updateTimeDisplay(duration);
  }
}

private function onNetStatus(event:NetStatusEvent):void {
  var msg:String = "";
  
  if (event.info.code)
    msg += event.info.code;
  
  if (event.info.level)
    msg += ", level: "+event.info.level;
  
  //log(msg);
}

private function onPlayPause():void {
  if (playBtn.selected) {
    ns.resume();
    timer.start();
  } else {
    ns.pause();
    timer.stop();
  }
}

private function onTimer(event:TimerEvent):void {
  updateTimeDisplay(formatSeconds(ns.time));
}

private function updateTimeDisplay(time:String):void {
  if (duration) 
    time += " / "+duration;
  
  timeDisplay.text = time;
}

private function formatSeconds(time:Number):String {
  var minutes:int = time / 60;
  var seconds:int = int(time) % 60;
  
  return String(minutes+":"+(seconds<10 ? "0" : "")+seconds);
}

private function log(msg:String, showUser:Boolean=true):void {
  trace(msg);
  if (showUser)
    logger.text += msg + "\n";
}
