/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.client;

import android.content.Context;
import android.os.Parcel;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.internal.client.zzh;
import com.google.android.gms.ads.internal.client.zzk;
import com.google.android.gms.ads.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzgk;

@zzgk
public final class AdSizeParcel
implements SafeParcelable {
    public static final zzh CREATOR = new zzh();
    public final int versionCode;
    public final String zzsG;
    public final int height;
    public final int heightPixels;
    public final boolean zzsH;
    public final int width;
    public final int widthPixels;
    public final AdSizeParcel[] zzsI;
    public final boolean zzsJ;

    public static int zza(DisplayMetrics displayMetrics) {
        return displayMetrics.widthPixels;
    }

    public static int zzb(DisplayMetrics displayMetrics) {
        return (int)((float)AdSizeParcel.zzc(displayMetrics) * displayMetrics.density);
    }

    private static int zzc(DisplayMetrics displayMetrics) {
        int n = (int)((float)displayMetrics.heightPixels / displayMetrics.density);
        if (n <= 400) {
            return 32;
        }
        if (n <= 720) {
            return 50;
        }
        return 90;
    }

    public static AdSizeParcel zzs(Context context) {
        return new AdSizeParcel(3, "320x50_mb", 0, 0, false, 0, 0, null, true);
    }

    public static AdSizeParcel zzcB() {
        return new AdSizeParcel(3, "reward_mb", 0, 0, false, 0, 0, null, false);
    }

    public AdSizeParcel() {
        this(3, "interstitial_mb", 0, 0, true, 0, 0, null, false);
    }

    public AdSizeParcel(Context context, AdSize adSize) {
        this(context, new AdSize[]{adSize});
    }

    public AdSizeParcel(Context context, AdSize[] adSizes) {
        int n;
        AdSize adSize = adSizes[0];
        this.versionCode = 3;
        this.zzsH = false;
        this.width = adSize.getWidth();
        this.height = adSize.getHeight();
        boolean bl = this.width == -1;
        boolean bl2 = this.height == -2;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        if (bl) {
            this.widthPixels = zzk.zzcE().zzS(context) && zzk.zzcE().zzT(context) ? AdSizeParcel.zza(displayMetrics) - zzk.zzcE().zzU(context) : AdSizeParcel.zza(displayMetrics);
            double d = (float)this.widthPixels / displayMetrics.density;
            n = (int)d;
            if (d - (double)((int)d) >= 0.01) {
                ++n;
            }
        } else {
            n = this.width;
            this.widthPixels = zzk.zzcE().zza(displayMetrics, this.width);
        }
        int n2 = bl2 ? AdSizeParcel.zzc(displayMetrics) : this.height;
        this.heightPixels = zzk.zzcE().zza(displayMetrics, n2);
        this.zzsG = bl || bl2 ? n + "x" + n2 + "_as" : adSize.toString();
        if (adSizes.length > 1) {
            this.zzsI = new AdSizeParcel[adSizes.length];
            for (int i = 0; i < adSizes.length; ++i) {
                this.zzsI[i] = new AdSizeParcel(context, adSizes[i]);
            }
        } else {
            this.zzsI = null;
        }
        this.zzsJ = false;
    }

    public AdSizeParcel(AdSizeParcel adSize, AdSizeParcel[] supportedAdSizes) {
        this(3, adSize.zzsG, adSize.height, adSize.heightPixels, adSize.zzsH, adSize.width, adSize.widthPixels, supportedAdSizes, adSize.zzsJ);
    }

    AdSizeParcel(int versionCode, String formatString, int height, int heightPixels, boolean isInterstitial, int width, int widthPixels, AdSizeParcel[] supportedAdSizes, boolean isNative) {
        this.versionCode = versionCode;
        this.zzsG = formatString;
        this.height = height;
        this.heightPixels = heightPixels;
        this.zzsH = isInterstitial;
        this.width = width;
        this.widthPixels = widthPixels;
        this.zzsI = supportedAdSizes;
        this.zzsJ = isNative;
    }

    public int describeContents() {
        return 0;
    }

    public AdSize zzcC() {
        return zza.zza(this.width, this.height, this.zzsG);
    }

    public void writeToParcel(Parcel out, int flags) {
        zzh.zza(this, out, flags);
    }
}

