/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.gcm;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.gcm.GcmTaskService;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.google.android.gms.gcm.Task;
import java.util.List;

public class GcmNetworkManager {
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_RESCHEDULE = 1;
    public static final int RESULT_FAILURE = 2;
    private static GcmNetworkManager zzazG;
    private Context mContext;
    private final PendingIntent mPendingIntent;

    public static GcmNetworkManager getInstance(Context context) {
        if (zzazG == null) {
            zzazG = new GcmNetworkManager(context.getApplicationContext());
        }
        return zzazG;
    }

    private GcmNetworkManager(Context context) {
        this.mContext = context;
        this.mPendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent(), (int)0);
    }

    public void schedule(Task task) {
        this.zzdj(task.getServiceName());
        Intent intent = this.zzvl();
        if (intent == null) {
            return;
        }
        Bundle bundle = intent.getExtras();
        bundle.putString("scheduler_action", "SCHEDULE_TASK");
        task.toBundle(bundle);
        intent.putExtras(bundle);
        this.mContext.sendBroadcast(intent);
    }

    public void cancelTask(String tag, Class<? extends GcmTaskService> gcmTaskService) {
        GcmNetworkManager.zzdi(tag);
        this.zzdj(gcmTaskService.getName());
        Intent intent = this.zzvl();
        if (intent == null) {
            return;
        }
        intent.putExtra("scheduler_action", "CANCEL_TASK");
        intent.putExtra("tag", tag);
        intent.putExtra("component", (Parcelable)new ComponentName(this.mContext, gcmTaskService));
        this.mContext.sendBroadcast(intent);
    }

    public void cancelAllTasks(Class<? extends GcmTaskService> gcmTaskService) {
        this.zzdj(gcmTaskService.getName());
        Intent intent = this.zzvl();
        if (intent == null) {
            return;
        }
        intent.putExtra("scheduler_action", "CANCEL_ALL");
        intent.putExtra("component", (Parcelable)new ComponentName(this.mContext, gcmTaskService));
        this.mContext.sendBroadcast(intent);
    }

    private Intent zzvl() {
        int n = GoogleCloudMessaging.zzaA(this.mContext);
        if (n < GoogleCloudMessaging.zzazR) {
            Log.e((String)"GcmNetworkManager", (String)("Google Play Services is not available, dropping GcmNetworkManager request. code=" + n));
            return null;
        }
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_SCHEDULE");
        intent.setPackage(GoogleCloudMessaging.zzaz(this.mContext));
        intent.putExtra("app", (Parcelable)this.mPendingIntent);
        return intent;
    }

    static void zzdi(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Must provide a valid tag.");
        }
        if (100 < string.length()) {
            throw new IllegalArgumentException("Tag is larger than max permissible tag length (100)");
        }
    }

    private void zzdj(String string) {
        zzx.zzb((Object)string, (Object)"GcmTaskService must not be null.");
        Intent intent = new Intent("com.google.android.gms.gcm.ACTION_TASK_READY");
        intent.setPackage(this.mContext.getPackageName());
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryIntentServices(intent, 0);
        zzx.zzb((list != null && list.size() != 0 ? 1 : 0) != 0, (Object)"There is no GcmTaskService component registered within this package. Have you extended GcmTaskService correctly?");
        boolean bl = false;
        for (ResolveInfo resolveInfo : list) {
            if (!resolveInfo.serviceInfo.name.equals(string)) continue;
            bl = true;
            break;
        }
        zzx.zzb((boolean)bl, (Object)("The GcmTaskService class you provided " + string + " does not seem to support receiving" + " com.google.android.gms.gcm.ACTION_TASK_READY."));
    }
}

