/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveContents;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.ExecutionOptions;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.zzam;
import com.google.android.gms.drive.internal.zzbj;
import com.google.android.gms.drive.internal.zzbr;
import com.google.android.gms.drive.internal.zzr;
import com.google.android.gms.drive.internal.zzs;
import com.google.android.gms.drive.internal.zzt;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.internal.zzlr;
import java.io.InputStream;
import java.io.OutputStream;

public class zzu
implements DriveContents {
    private final Contents zzaiD;
    private boolean mClosed = false;
    private boolean zzaiE = false;
    private boolean zzaiF = false;

    public zzu(Contents contents) {
        this.zzaiD = (Contents)zzx.zzv((Object)contents);
    }

    @Override
    public DriveId getDriveId() {
        return this.zzaiD.getDriveId();
    }

    @Override
    public int getMode() {
        return this.zzaiD.getMode();
    }

    @Override
    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.zzqj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        return this.zzaiD.getParcelFileDescriptor();
    }

    @Override
    public InputStream getInputStream() {
        if (this.zzqj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the input stream.");
        }
        if (this.zzaiD.getMode() != 0x10000000) {
            throw new IllegalStateException("getInputStream() can only be used with contents opened with MODE_READ_ONLY.");
        }
        if (this.zzaiE) {
            throw new IllegalStateException("getInputStream() can only be called once per Contents instance.");
        }
        this.zzaiE = true;
        return this.zzaiD.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.zzqj()) {
            throw new IllegalStateException("Contents have been closed, cannot access the output stream.");
        }
        if (this.zzaiD.getMode() != 0x20000000) {
            throw new IllegalStateException("getOutputStream() can only be used with contents opened with MODE_WRITE_ONLY.");
        }
        if (this.zzaiF) {
            throw new IllegalStateException("getOutputStream() can only be called once per Contents instance.");
        }
        this.zzaiF = true;
        return this.zzaiD.getOutputStream();
    }

    @Override
    public PendingResult<DriveApi.DriveContentsResult> reopenForWrite(GoogleApiClient apiClient) {
        if (this.zzqj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.zzaiD.getMode() != 0x10000000) {
            throw new IllegalStateException("reopenForWrite can only be used with DriveContents opened with MODE_READ_ONLY.");
        }
        this.zzqi();
        return apiClient.zza((zzc.zza)new zzr.zzb(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new OpenContentsRequest(zzu.this.getDriveId(), 0x20000000, zzu.this.zzaiD.getRequestId()), (zzam)new zzbj((zzc.zzb<DriveApi.DriveContentsResult>)this, null));
            }
        });
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet) {
        return this.commit(apiClient, changeSet, null);
    }

    @Override
    public PendingResult<Status> commit(GoogleApiClient apiClient, MetadataChangeSet changeSet, ExecutionOptions executionOptions) {
        if (executionOptions == null) {
            executionOptions = new ExecutionOptions.Builder().build();
        }
        if (this.zzaiD.getMode() == 0x10000000) {
            throw new IllegalStateException("Cannot commit contents opened with MODE_READ_ONLY");
        }
        if (ExecutionOptions.zzcf(executionOptions.zzqn()) && !this.zzaiD.zzqf()) {
            throw new IllegalStateException("DriveContents must be valid for conflict detection.");
        }
        ExecutionOptions.zza(apiClient, executionOptions);
        if (this.zzqj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        if (this.getDriveId() == null) {
            throw new IllegalStateException("Only DriveContents obtained through DriveFile.open can be committed.");
        }
        final MetadataChangeSet metadataChangeSet = changeSet != null ? changeSet : MetadataChangeSet.zzagR;
        final ExecutionOptions executionOptions2 = executionOptions;
        this.zzqi();
        return apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                metadataChangeSet.zzqp().setContext(zzt2.getContext());
                zzt2.zzqF().zza(new CloseContentsAndUpdateMetadataRequest(zzu.this.zzaiD.getDriveId(), metadataChangeSet.zzqp(), zzu.this.zzaiD.getRequestId(), zzu.this.zzaiD.zzqf(), executionOptions2), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        });
    }

    @Override
    public void discard(GoogleApiClient apiClient) {
        if (this.zzqj()) {
            throw new IllegalStateException("DriveContents already closed.");
        }
        this.zzqi();
        (apiClient.zzb((zzc.zza)new zzs.zza(apiClient){

            protected void zza(zzt zzt2) throws RemoteException {
                zzt2.zzqF().zza(new CloseContentsRequest(zzu.this.zzaiD.getRequestId(), false), (zzam)new zzbr((zzc.zzb<Status>)this));
            }
        })).setResultCallback((ResultCallback)new ResultCallback<Status>(){

            public void zzr(Status status) {
                if (!status.isSuccess()) {
                    zzy.zzx("DriveContentsImpl", "Error discarding contents");
                } else {
                    zzy.zzv("DriveContentsImpl", "Contents discarded");
                }
            }

            public /* synthetic */ void onResult(Result x0) {
                this.zzr((Status)x0);
            }
        });
    }

    @Override
    public Contents zzqh() {
        return this.zzaiD;
    }

    @Override
    public void zzqi() {
        zzlr.zza((ParcelFileDescriptor)this.zzaiD.getParcelFileDescriptor());
        this.mClosed = true;
    }

    @Override
    public boolean zzqj() {
        return this.mClosed;
    }
}

