/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.view.Window;
import com.google.android.gms.ads.internal.InterstitialAdParameterParcel;
import com.google.android.gms.ads.internal.client.AdRequestParcel;
import com.google.android.gms.ads.internal.client.AdSizeParcel;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.util.client.VersionInfoParcel;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzc;
import com.google.android.gms.ads.internal.zzd;
import com.google.android.gms.ads.internal.zze;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzaz;
import com.google.android.gms.internal.zzby;
import com.google.android.gms.internal.zzcd;
import com.google.android.gms.internal.zzdk;
import com.google.android.gms.internal.zzeh;
import com.google.android.gms.internal.zzgk;
import com.google.android.gms.internal.zzhj;
import com.google.android.gms.internal.zzip;

@zzgk
public class zzk
extends zzc
implements zzdk {
    protected transient boolean zzpj = false;

    public zzk(Context context, AdSizeParcel adSizeParcel, String string, zzeh zzeh2, VersionInfoParcel versionInfoParcel, zzd zzd2) {
        super(context, adSizeParcel, string, zzeh2, versionInfoParcel, zzd2);
    }

    @Override
    public boolean zza(AdRequestParcel adRequestParcel, zzcd zzcd2) {
        if (this.zzos.zzqg != null) {
            zzb.zzaE("An interstitial is already loading. Aborting.");
            return false;
        }
        return super.zza(adRequestParcel, zzcd2);
    }

    @Override
    protected zzip zza(zzhj.zza zza2, zze zze2) {
        zzip zzip2 = null;
        zzip2 = zzp.zzby().zza(this.zzos.context, this.zzos.zzqf, false, false, this.zzos.zzqa, this.zzos.zzqb, this.zzov);
        zzip2.zzgS().zzb(this, null, this, this, zzby.zzuN.get(), this, this, zze2, null);
        zzip2.zzaG(zza2.zzGL.zzDQ);
        return zzip2;
    }

    @Override
    protected boolean zza(AdRequestParcel adRequestParcel, zzhj zzhj2, boolean bl) {
        if (this.zzos.zzbP() && zzhj2.zzAR != null) {
            zzp.zzbz().zza(zzhj2.zzAR.getWebView());
        }
        return this.zzor.zzbr();
    }

    @Override
    public boolean zza(zzhj zzhj2, zzhj zzhj3) {
        if (!super.zza(zzhj2, zzhj3)) {
            return false;
        }
        if (!this.zzos.zzbP() && this.zzos.zzqy != null && zzhj3.zzGF != null) {
            zzaz zzaz2 = this.zzou.zza(this.zzos.zzqf, zzhj3, this.zzos.zzqy);
        }
        return true;
    }

    @Override
    public void zzaV() {
        this.zzbm();
        super.zzaV();
    }

    @Override
    public void zzaW() {
        this.recordImpression();
        super.zzaW();
    }

    @Override
    public void zzd(boolean bl) {
        this.zzos.zzpk = bl;
    }

    @Override
    public void showInterstitial() {
        Object object;
        zzx.zzch((String)"showInterstitial must be called on the main UI thread.");
        if (this.zzos.zzqg == null) {
            zzb.zzaE("The interstitial has not loaded.");
            return;
        }
        if (zzby.zzuZ.get().booleanValue()) {
            Bundle bundle;
            Object object2 = object = this.zzos.context.getApplicationContext() != null ? this.zzos.context.getApplicationContext().getPackageName() : this.zzos.context.getPackageName();
            if (!this.zzpj) {
                zzb.zzaE("It is not recommended to show an interstitial before onAdLoaded completes.");
                bundle = new Bundle();
                bundle.putString("appid", (String)object);
                bundle.putString("action", "show_interstitial_before_load_finish");
                this.zzb(bundle);
            }
            if (!zzp.zzbx().zzO(this.zzos.context)) {
                zzb.zzaE("It is not recommended to show an interstitial when app is not in foreground.");
                bundle = new Bundle();
                bundle.putString("appid", (String)object);
                bundle.putString("action", "show_interstitial_app_not_in_foreground");
                this.zzb(bundle);
            }
        }
        if (this.zzos.zzbQ()) {
            return;
        }
        if (this.zzos.zzqg.zzDX) {
            try {
                this.zzos.zzqg.zzyR.showInterstitial();
            }
            catch (RemoteException remoteException) {
                zzb.zzd("Could not show interstitial.", remoteException);
                this.zzbm();
            }
        } else {
            if (this.zzos.zzqg.zzAR == null) {
                zzb.zzaE("The interstitial failed to load.");
                return;
            }
            if (this.zzos.zzqg.zzAR.zzgW()) {
                zzb.zzaE("The interstitial is already showing.");
                return;
            }
            this.zzos.zzqg.zzAR.zzC(true);
            if (this.zzos.zzqg.zzGF != null) {
                this.zzou.zza(this.zzos.zzqf, this.zzos.zzqg);
            }
            object = new InterstitialAdParameterParcel(this.zzos.zzpk, this.zzbl());
            int n = this.zzos.zzqg.zzAR.getRequestedOrientation();
            if (n == -1) {
                n = this.zzos.zzqg.orientation;
            }
            AdOverlayInfoParcel adOverlayInfoParcel = new AdOverlayInfoParcel(this, this, this, this.zzos.zzqg.zzAR, n, this.zzos.zzqb, this.zzos.zzqg.zzEc, (InterstitialAdParameterParcel)object);
            zzp.zzbv().zza(this.zzos.context, adOverlayInfoParcel);
        }
    }

    private void zzb(Bundle bundle) {
        zzp.zzbx().zzb(this.zzos.context, this.zzos.zzqb.zzIz, "gmob-apps", bundle, false);
    }

    protected boolean zzbl() {
        if (!(this.zzos.context instanceof Activity)) {
            return false;
        }
        Window window = ((Activity)this.zzos.context).getWindow();
        if (window == null || window.getDecorView() == null) {
            return false;
        }
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        window.getDecorView().getGlobalVisibleRect(rect, null);
        window.getDecorView().getWindowVisibleDisplayFrame(rect2);
        return rect.bottom != 0 && rect2.bottom != 0 && rect.top == rect2.top;
    }

    @Override
    protected boolean zzaT() {
        if (super.zzaT()) {
            this.zzpj = true;
            return true;
        }
        return false;
    }

    private void zzbm() {
        if (this.zzos.zzbP()) {
            this.zzos.zzbM();
            this.zzos.zzqg = null;
            this.zzos.zzpk = false;
            this.zzpj = false;
        }
    }
}

