/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataPoint;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.RawDataSet;
import com.google.android.gms.fitness.data.zze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class DataSet
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzanm;
    private final DataType zzanl;
    private final List<DataPoint> zzanH;
    private final List<DataSource> zzanI;
    private boolean zzanA = false;
    public static final Parcelable.Creator<DataSet> CREATOR = new zze();

    DataSet(int versionCode, DataSource dataSource, DataType dataType, List<RawDataPoint> dataPoints, List<DataSource> uniqueDataSources, boolean serverHasMoreData) {
        this.mVersionCode = versionCode;
        this.zzanm = dataSource;
        this.zzanl = dataSource.getDataType();
        this.zzanA = serverHasMoreData;
        this.zzanH = new ArrayList<DataPoint>(dataPoints.size());
        this.zzanI = versionCode >= 2 ? uniqueDataSources : Collections.singletonList(dataSource);
        for (RawDataPoint rawDataPoint : dataPoints) {
            this.zzanH.add(new DataPoint(this.zzanI, rawDataPoint));
        }
    }

    public DataSet(DataSource dataSource) {
        this.mVersionCode = 3;
        this.zzanm = (DataSource)zzx.zzv((Object)dataSource);
        this.zzanl = dataSource.getDataType();
        this.zzanH = new ArrayList<DataPoint>();
        this.zzanI = new ArrayList<DataSource>();
        this.zzanI.add(this.zzanm);
    }

    public DataSet(RawDataSet dataSet, List<DataSource> uniqueDataSources) {
        this.mVersionCode = 3;
        this.zzanm = DataSet.zzb(uniqueDataSources, dataSet.zzaow);
        this.zzanl = this.zzanm.getDataType();
        this.zzanI = uniqueDataSources;
        this.zzanA = dataSet.zzanA;
        List<RawDataPoint> list = dataSet.zzaoz;
        this.zzanH = new ArrayList<DataPoint>(list.size());
        for (RawDataPoint rawDataPoint : list) {
            this.zzanH.add(new DataPoint(this.zzanI, rawDataPoint));
        }
    }

    private static <T> T zzb(List<T> list, int n) {
        return n >= 0 && n < list.size() ? (T)list.get(n) : null;
    }

    public static DataSet create(DataSource dataSource) {
        zzx.zzb((Object)dataSource, (Object)"DataSource should be specified");
        return new DataSet(dataSource);
    }

    public DataPoint createDataPoint() {
        return DataPoint.create(this.zzanm);
    }

    public void add(DataPoint dataPoint) {
        DataSource dataSource = dataPoint.getDataSource();
        zzx.zzb((boolean)dataSource.getStreamIdentifier().equals(this.zzanm.getStreamIdentifier()), (String)"Conflicting data sources found %s vs %s", (Object[])new Object[]{dataSource, this.zzanm});
        dataPoint.zzrB();
        this.zzb(dataPoint);
    }

    public void zzb(DataPoint dataPoint) {
        this.zzanH.add(dataPoint);
        DataSource dataSource = dataPoint.getOriginalDataSource();
        if (dataSource != null && !this.zzanI.contains(dataSource)) {
            this.zzanI.add(dataSource);
        }
    }

    public void addAll(Iterable<DataPoint> dataPoints) {
        for (DataPoint dataPoint : dataPoints) {
            this.add(dataPoint);
        }
    }

    public void zzb(Iterable<DataPoint> iterable) {
        for (DataPoint dataPoint : iterable) {
            this.zzb(dataPoint);
        }
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public DataType getDataType() {
        return this.zzanm.getDataType();
    }

    public List<DataPoint> getDataPoints() {
        return Collections.unmodifiableList(this.zzanH);
    }

    public boolean isEmpty() {
        return this.zzanH.isEmpty();
    }

    public boolean zzrv() {
        return this.zzanA;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataSet && this.zza((DataSet)o);
    }

    private boolean zza(DataSet dataSet) {
        return zzw.equal((Object)this.getDataType(), (Object)dataSet.getDataType()) && zzw.equal((Object)this.zzanm, (Object)dataSet.zzanm) && zzw.equal(this.zzanH, dataSet.zzanH) && this.zzanA == dataSet.zzanA;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm});
    }

    public String toString() {
        List<RawDataPoint> list = this.zzrD();
        return String.format("DataSet{%s %s}", this.zzanm.toDebugString(), this.zzanH.size() < 10 ? list : String.format("%d data points, first 5: %s", this.zzanH.size(), list.subList(0, 5)));
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    List<RawDataPoint> zzrD() {
        return this.zzk(this.zzanI);
    }

    List<RawDataPoint> zzk(List<DataSource> list) {
        ArrayList<RawDataPoint> arrayList = new ArrayList<RawDataPoint>(this.zzanH.size());
        for (DataPoint dataPoint : this.zzanH) {
            arrayList.add(new RawDataPoint(dataPoint, list));
        }
        return arrayList;
    }

    List<DataSource> zzrE() {
        return this.zzanI;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zze.zza(this, parcel, flags);
    }
}

