/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.google.android.gms.tagmanager.zzac;
import com.google.android.gms.tagmanager.zzaq;
import com.google.android.gms.tagmanager.zzbg;
import com.google.android.gms.tagmanager.zzbl;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;

class zzcx
implements zzac {
    private final String zzaSp;
    private final HttpClient zzaSq;
    private final Context zzaRY;
    private zza zzaSr;

    zzcx(HttpClient httpClient, Context context, zza zza2) {
        this.zzaRY = context.getApplicationContext();
        this.zzaSp = this.zza("GoogleTagManager", "4.00", Build.VERSION.RELEASE, zzcx.zzc(Locale.getDefault()), Build.MODEL, Build.ID);
        this.zzaSq = httpClient;
        this.zzaSr = zza2;
    }

    @Override
    public boolean zzzX() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.zzaRY.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null || !networkInfo.isConnected()) {
            zzbg.v("...no network connectivity");
            return false;
        }
        return true;
    }

    @Override
    public void zzr(List<zzaq> list) {
        int n = Math.min(list.size(), 40);
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            zzaq zzaq2 = list.get(i);
            URL uRL = this.zzd(zzaq2);
            if (uRL == null) {
                zzbg.zzaE("No destination: discarding hit.");
                this.zzaSr.zzb(zzaq2);
                continue;
            }
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = this.zzd(uRL);
            if (httpEntityEnclosingRequest == null) {
                this.zzaSr.zzb(zzaq2);
                continue;
            }
            HttpHost httpHost = new HttpHost(uRL.getHost(), uRL.getPort(), uRL.getProtocol());
            httpEntityEnclosingRequest.addHeader("Host", httpHost.toHostString());
            this.zza(httpEntityEnclosingRequest);
            try {
                if (bl) {
                    zzbl.zzaQ(this.zzaRY);
                    bl = false;
                }
                HttpResponse httpResponse = this.zzaSq.execute(httpHost, (HttpRequest)httpEntityEnclosingRequest);
                int n2 = httpResponse.getStatusLine().getStatusCode();
                HttpEntity httpEntity = httpResponse.getEntity();
                if (httpEntity != null) {
                    httpEntity.consumeContent();
                }
                if (n2 != 200) {
                    zzbg.zzaE("Bad response: " + httpResponse.getStatusLine().getStatusCode());
                    this.zzaSr.zzc(zzaq2);
                    continue;
                }
                this.zzaSr.zza(zzaq2);
                continue;
            }
            catch (ClientProtocolException clientProtocolException) {
                zzbg.zzaE("ClientProtocolException sending hit; discarding hit...");
                this.zzaSr.zzb(zzaq2);
                continue;
            }
            catch (IOException iOException) {
                zzbg.zzaE("Exception sending hit: " + iOException.getClass().getSimpleName());
                zzbg.zzaE(iOException.getMessage());
                this.zzaSr.zzc(zzaq2);
            }
        }
    }

    private HttpEntityEnclosingRequest zzd(URL uRL) {
        BasicHttpEntityEnclosingRequest basicHttpEntityEnclosingRequest = null;
        try {
            basicHttpEntityEnclosingRequest = new BasicHttpEntityEnclosingRequest("GET", uRL.toURI().toString());
            basicHttpEntityEnclosingRequest.addHeader("User-Agent", this.zzaSp);
        }
        catch (URISyntaxException uRISyntaxException) {
            zzbg.zzaE("Exception sending hit: " + uRISyntaxException.getClass().getSimpleName());
            zzbg.zzaE(uRISyntaxException.getMessage());
        }
        return basicHttpEntityEnclosingRequest;
    }

    private void zza(HttpEntityEnclosingRequest httpEntityEnclosingRequest) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Header header : httpEntityEnclosingRequest.getAllHeaders()) {
            stringBuffer.append(header.toString()).append("\n");
        }
        stringBuffer.append(httpEntityEnclosingRequest.getRequestLine().toString()).append("\n");
        if (httpEntityEnclosingRequest.getEntity() != null) {
            try {
                int n;
                InputStream inputStream = httpEntityEnclosingRequest.getEntity().getContent();
                if (inputStream != null && (n = inputStream.available()) > 0) {
                    byte[] byArray = new byte[n];
                    inputStream.read(byArray);
                    stringBuffer.append("POST:\n");
                    stringBuffer.append(new String(byArray)).append("\n");
                }
            }
            catch (IOException iOException) {
                zzbg.v("Error Writing hit to log...");
            }
        }
        zzbg.v(stringBuffer.toString());
    }

    String zza(String string, String string2, String string3, String string4, String string5, String string6) {
        return String.format("%s/%s (Linux; U; Android %s; %s; %s Build/%s)", string, string2, string3, string4, string5, string6);
    }

    static String zzc(Locale locale) {
        if (locale == null) {
            return null;
        }
        if (locale.getLanguage() == null || locale.getLanguage().length() == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(locale.getLanguage().toLowerCase());
        if (locale.getCountry() != null && locale.getCountry().length() != 0) {
            stringBuilder.append("-").append(locale.getCountry().toLowerCase());
        }
        return stringBuilder.toString();
    }

    URL zzd(zzaq zzaq2) {
        String string = zzaq2.zzAg();
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            zzbg.e("Error trying to parse the GTM url.");
            return null;
        }
    }

    public static interface zza {
        public void zza(zzaq var1);

        public void zzb(zzaq var1);

        public void zzc(zzaq var1);
    }
}

