/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.Context;
import android.text.TextUtils;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzam;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

public class zza
extends zzd {
    public static boolean zzLk;
    private AdvertisingIdClient.Info zzLl;
    private final zzaj zzLm;
    private String zzLn;
    private boolean zzLo = false;
    private Object zzLp = new Object();

    zza(zzf zzf2) {
        super(zzf2);
        this.zzLm = new zzaj(zzf2.zzid());
    }

    @Override
    protected void zzhB() {
    }

    public boolean zzhM() {
        this.zzio();
        AdvertisingIdClient.Info info = this.zzhR();
        if (info != null) {
            return !info.isLimitAdTrackingEnabled();
        }
        return false;
    }

    public String zzhQ() {
        this.zzio();
        AdvertisingIdClient.Info info = this.zzhR();
        String string = null;
        if (info != null) {
            string = info.getId();
        }
        if (TextUtils.isEmpty(string)) {
            return null;
        }
        return string;
    }

    private synchronized AdvertisingIdClient.Info zzhR() {
        if (this.zzLm.zzv(1000L)) {
            this.zzLm.start();
            AdvertisingIdClient.Info info = this.zzhS();
            if (this.zza(this.zzLl, info)) {
                this.zzLl = info;
            } else {
                this.zzbc("Failed to reset client id on adid change. Not using adid");
                this.zzLl = new AdvertisingIdClient.Info("", false);
            }
        }
        return this.zzLl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(AdvertisingIdClient.Info info, AdvertisingIdClient.Info info2) {
        String string;
        String string2 = string = info2 == null ? null : info2.getId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return true;
        }
        String string3 = this.zzij().zzjd();
        Object object = this.zzLp;
        synchronized (object) {
            String string4;
            if (!this.zzLo) {
                this.zzLn = this.zzhT();
                this.zzLo = true;
            } else if (TextUtils.isEmpty((CharSequence)this.zzLn)) {
                String string5 = string4 = info == null ? null : info.getId();
                if (string4 == null) {
                    return this.zzaX(string + string3);
                }
                this.zzLn = zza.zzaW(string4 + string3);
            }
            string4 = zza.zzaW(string + string3);
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            if (string4.equals(this.zzLn)) {
                return true;
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzLn)) {
                this.zzaY("Resetting the client id because Advertising Id changed.");
                string3 = this.zzij().zzje();
                this.zza("New client Id", string3);
            }
            return this.zzaX(string + string3);
        }
    }

    protected AdvertisingIdClient.Info zzhS() {
        AdvertisingIdClient.Info info;
        block3: {
            info = null;
            try {
                info = AdvertisingIdClient.getAdvertisingIdInfo(this.getContext());
            }
            catch (IllegalStateException illegalStateException) {
                this.zzbb("IllegalStateException getting Ad Id Info. If you would like to see Audience reports, please ensure that you have added '<meta-data android:name=\"com.google.android.gms.version\" android:value=\"@integer/google_play_services_version\" />' to your application manifest file. See http://goo.gl/naFqQk for details.");
            }
            catch (Throwable throwable) {
                if (zzLk) break block3;
                zzLk = true;
                this.zzd("Error getting advertiser id", throwable);
            }
        }
        return info;
    }

    private static String zzaW(String string) {
        MessageDigest messageDigest = zzam.zzbq("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string.getBytes())));
    }

    private boolean zzaX(String string) {
        try {
            String string2 = zza.zzaW(string);
            this.zzaY("Storing hashed adid.");
            Context context = this.getContext();
            FileOutputStream fileOutputStream = context.openFileOutput("gaClientIdData", 0);
            fileOutputStream.write(string2.getBytes());
            fileOutputStream.close();
            this.zzLn = string2;
            return true;
        }
        catch (IOException iOException) {
            this.zze("Error creating hash file", iOException);
            return false;
        }
    }

    protected String zzhT() {
        String string = null;
        try {
            FileInputStream fileInputStream = this.getContext().openFileInput("gaClientIdData");
            byte[] byArray = new byte[128];
            int n = fileInputStream.read(byArray, 0, 128);
            if (fileInputStream.available() > 0) {
                this.zzbb("Hash file seems corrupted, deleting it.");
                fileInputStream.close();
                this.getContext().deleteFile("gaClientIdData");
            } else if (n <= 0) {
                this.zzaY("Hash file is empty.");
                fileInputStream.close();
            } else {
                string = new String(byArray, 0, n);
                fileInputStream.close();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            this.zzd("Error reading Hash file, deleting it", iOException);
            this.getContext().deleteFile("gaClientIdData");
        }
        return string;
    }
}

