/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.content.res.TypedArrayUtils;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.preference.R;
import android.support.v7.preference.TwoStatePreference;
import android.util.AttributeSet;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import android.widget.Checkable;

public class CheckBoxPreference
extends TwoStatePreference {
    public CheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public CheckBoxPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckBoxPreference, defStyleAttr, defStyleRes);
        this.setSummaryOn(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.CheckBoxPreference_summaryOn, (int)R.styleable.CheckBoxPreference_android_summaryOn));
        this.setSummaryOff(TypedArrayUtils.getString((TypedArray)a, (int)R.styleable.CheckBoxPreference_summaryOff, (int)R.styleable.CheckBoxPreference_android_summaryOff));
        this.setDisableDependentsState(TypedArrayUtils.getBoolean((TypedArray)a, (int)R.styleable.CheckBoxPreference_disableDependentsState, (int)R.styleable.CheckBoxPreference_android_disableDependentsState, (boolean)false));
        a.recycle();
    }

    public CheckBoxPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.checkBoxPreferenceStyle);
    }

    public CheckBoxPreference(Context context) {
        this(context, null);
    }

    @Override
    public void onBindViewHolder(PreferenceViewHolder holder) {
        super.onBindViewHolder(holder);
        View checkboxView = holder.findViewById(R.id.checkbox);
        if (checkboxView != null && checkboxView instanceof Checkable) {
            ((Checkable)checkboxView).setChecked(this.mChecked);
        }
        this.syncSummaryView(holder);
    }

    @Override
    protected void performClick(View view) {
        super.performClick(view);
        this.syncViewIfAccessibilityEnabled(view);
    }

    private void syncViewIfAccessibilityEnabled(View view) {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        if (!accessibilityManager.isEnabled()) {
            return;
        }
        View checkboxView = view.findViewById(R.id.checkbox);
        this.syncCheckboxView(checkboxView);
        View summaryView = view.findViewById(0x1020010);
        this.syncSummaryView(summaryView);
    }

    private void syncCheckboxView(View view) {
        if (view instanceof Checkable) {
            ((Checkable)view).setChecked(this.mChecked);
        }
    }
}

