/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.media;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.media.MediaRouter;
import android.os.Build;
import android.os.Handler;
import android.support.v7.media.MediaRouterJellybean;
import android.util.Log;
import android.view.Display;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class MediaRouterJellybeanMr1 {
    private static final String TAG = "MediaRouterJellybeanMr1";

    MediaRouterJellybeanMr1() {
    }

    public static Object createCallback(Callback callback) {
        return new CallbackProxy<Callback>(callback);
    }

    static class CallbackProxy<T extends Callback>
    extends MediaRouterJellybean.CallbackProxy<T> {
        public CallbackProxy(T callback) {
            super(callback);
        }

        public void onRoutePresentationDisplayChanged(MediaRouter router, MediaRouter.RouteInfo route) {
            ((Callback)this.mCallback).onRoutePresentationDisplayChanged(route);
        }
    }

    public static final class IsConnectingWorkaround {
        private Method mGetStatusCodeMethod;
        private int mStatusConnecting;

        public IsConnectingWorkaround() {
            if (Build.VERSION.SDK_INT != 17) {
                throw new UnsupportedOperationException();
            }
            try {
                Field statusConnectingField = MediaRouter.RouteInfo.class.getField("STATUS_CONNECTING");
                this.mStatusConnecting = statusConnectingField.getInt(null);
                this.mGetStatusCodeMethod = MediaRouter.RouteInfo.class.getMethod("getStatusCode", new Class[0]);
            }
            catch (NoSuchFieldException ex) {
            }
            catch (NoSuchMethodException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }

        public boolean isConnecting(Object routeObj) {
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)routeObj;
            if (this.mGetStatusCodeMethod != null) {
                try {
                    int statusCode = (Integer)this.mGetStatusCodeMethod.invoke((Object)route, new Object[0]);
                    return statusCode == this.mStatusConnecting;
                }
                catch (IllegalAccessException ex) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    public static final class ActiveScanWorkaround
    implements Runnable {
        private static final int WIFI_DISPLAY_SCAN_INTERVAL = 15000;
        private final DisplayManager mDisplayManager;
        private final Handler mHandler;
        private Method mScanWifiDisplaysMethod;
        private boolean mActivelyScanningWifiDisplays;

        public ActiveScanWorkaround(Context context, Handler handler) {
            if (Build.VERSION.SDK_INT != 17) {
                throw new UnsupportedOperationException();
            }
            this.mDisplayManager = (DisplayManager)context.getSystemService("display");
            this.mHandler = handler;
            try {
                this.mScanWifiDisplaysMethod = DisplayManager.class.getMethod("scanWifiDisplays", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }

        public void setActiveScanRouteTypes(int routeTypes) {
            if ((routeTypes & 2) != 0) {
                if (!this.mActivelyScanningWifiDisplays) {
                    if (this.mScanWifiDisplaysMethod != null) {
                        this.mActivelyScanningWifiDisplays = true;
                        this.mHandler.post((Runnable)this);
                    } else {
                        Log.w((String)MediaRouterJellybeanMr1.TAG, (String)"Cannot scan for wifi displays because the DisplayManager.scanWifiDisplays() method is not available on this device.");
                    }
                }
            } else if (this.mActivelyScanningWifiDisplays) {
                this.mActivelyScanningWifiDisplays = false;
                this.mHandler.removeCallbacks((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.mActivelyScanningWifiDisplays) {
                try {
                    this.mScanWifiDisplaysMethod.invoke((Object)this.mDisplayManager, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    Log.w((String)MediaRouterJellybeanMr1.TAG, (String)"Cannot scan for wifi displays.", (Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Log.w((String)MediaRouterJellybeanMr1.TAG, (String)"Cannot scan for wifi displays.", (Throwable)ex);
                }
                this.mHandler.postDelayed((Runnable)this, 15000L);
            }
        }
    }

    public static interface Callback
    extends MediaRouterJellybean.Callback {
        public void onRoutePresentationDisplayChanged(Object var1);
    }

    public static final class RouteInfo {
        public static boolean isEnabled(Object routeObj) {
            return ((MediaRouter.RouteInfo)routeObj).isEnabled();
        }

        public static Display getPresentationDisplay(Object routeObj) {
            return ((MediaRouter.RouteInfo)routeObj).getPresentationDisplay();
        }
    }
}

