/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.appdatasearch;

import android.accounts.Account;
import android.os.Parcel;
import com.google.android.gms.appdatasearch.DocumentSection;
import com.google.android.gms.appdatasearch.zzb;
import com.google.android.gms.appdatasearch.zzh;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzx;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class DocumentContents
implements SafeParcelable {
    public static final zzb CREATOR = new zzb();
    final int mVersionCode;
    final DocumentSection[] zzOS;
    public final String zzOT;
    public final boolean zzOU;
    public final Account account;

    DocumentContents(int versionCode, DocumentSection[] sectionContents, String schemaOrgType, boolean globalSearchEnabled, Account account) {
        this.mVersionCode = versionCode;
        this.zzOS = sectionContents;
        this.zzOT = schemaOrgType;
        this.zzOU = globalSearchEnabled;
        this.account = account;
    }

    DocumentContents(String schemaOrgType, boolean globalSearchEnabled, Account account, DocumentSection ... sections) {
        this(1, sections, schemaOrgType, globalSearchEnabled, account);
        BitSet bitSet = new BitSet(zzh.zzlc());
        for (int i = 0; i < sections.length; ++i) {
            int n = sections[i].zzPg;
            if (n == -1) continue;
            if (bitSet.get(n)) {
                throw new IllegalArgumentException("Duplicate global search section type " + zzh.zzaj(n));
            }
            bitSet.set(n);
        }
    }

    public String zzkX() {
        DocumentSection documentSection = this.zzbu("web_url");
        if (documentSection != null) {
            return documentSection.zzPe;
        }
        return null;
    }

    public DocumentSection zzbu(String string) {
        zzx.zzcs((String)string);
        if (this.zzOS == null) {
            return null;
        }
        for (DocumentSection documentSection : this.zzOS) {
            if (!string.equals(documentSection.zzkZ().name)) continue;
            return documentSection;
        }
        return null;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzb.zza(this, dest, flags);
    }

    public static class zza {
        private List<DocumentSection> zzOV;
        private String zzOW;
        private boolean zzOX;
        private Account zzOY;

        public zza zza(DocumentSection documentSection) {
            if (this.zzOV == null) {
                this.zzOV = new ArrayList<DocumentSection>();
            }
            this.zzOV.add(documentSection);
            return this;
        }

        public zza zzbv(String string) {
            this.zzOW = string;
            return this;
        }

        public zza zzK(boolean bl) {
            this.zzOX = bl;
            return this;
        }

        public zza zza(Account account) {
            this.zzOY = account;
            return this;
        }

        public DocumentContents zzkY() {
            return new DocumentContents(this.zzOW, this.zzOX, this.zzOY, this.zzOV != null ? this.zzOV.toArray(new DocumentSection[this.zzOV.size()]) : null);
        }
    }
}

