/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import java.nio.ByteBuffer;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private Metadata zzaVd = new Metadata();
    private ByteBuffer zzaVe = null;
    private Bitmap mBitmap = null;

    public Metadata getMetadata() {
        return this.zzaVd;
    }

    public ByteBuffer getGrayscaleImageData() {
        if (this.mBitmap != null) {
            return this.zzCc();
        }
        return this.zzaVe;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    private Frame() {
    }

    private ByteBuffer zzCc() {
        int n = this.mBitmap.getWidth();
        int n2 = this.mBitmap.getHeight();
        int[] nArray = new int[n * n2];
        this.mBitmap.getPixels(nArray, 0, n, 0, 0, n, n2);
        byte[] byArray = new byte[n * n2];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        System.arraycopy(byArray, 0, byteBuffer.array(), 0, byArray.length);
        return byteBuffer;
    }

    public static class Metadata {
        private int zznP;
        private int zznQ;
        private int mId;
        private long zzaxC;
        private int zzzS;

        public Metadata() {
        }

        public Metadata(Metadata metadata) {
            this.zznP = metadata.getWidth();
            this.zznQ = metadata.getHeight();
            this.mId = metadata.getId();
            this.zzaxC = metadata.getTimestampMillis();
            this.zzzS = metadata.getRotation();
        }

        public int getWidth() {
            return this.zznP;
        }

        public int getHeight() {
            return this.zznQ;
        }

        public int getId() {
            return this.mId;
        }

        public long getTimestampMillis() {
            return this.zzaxC;
        }

        public int getRotation() {
            return this.zzzS;
        }

        public void zzCd() {
            if (this.zzzS % 2 != 0) {
                int n = this.zznP;
                this.zznP = this.zznQ;
                this.zznQ = n;
            }
            this.zzzS = 0;
        }
    }

    public static class Builder {
        private Frame zzaVf = new Frame();

        public Builder setBitmap(Bitmap image) {
            int n = image.getWidth();
            int n2 = image.getHeight();
            this.zzaVf.mBitmap = image;
            Metadata metadata = this.zzaVf.getMetadata();
            metadata.zznP = n;
            metadata.zznQ = n2;
            return this;
        }

        public Builder setImageData(ByteBuffer data, int width, int height, int format) {
            if (data == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (!data.isDirect()) {
                throw new IllegalArgumentException("Image byte buffer must be allocated as 'direct'. See ByteBuffer.allocateDirect().");
            }
            if (data.array() == null || data.array().length < width * height) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (format) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported image format: " + format);
                }
            }
            this.zzaVf.zzaVe = data;
            Metadata metadata = this.zzaVf.getMetadata();
            metadata.zznP = width;
            metadata.zznQ = height;
            return this;
        }

        public Builder setId(int id) {
            this.zzaVf.getMetadata().mId = id;
            return this;
        }

        public Builder setTimestampMillis(long timestampMillis) {
            this.zzaVf.getMetadata().zzaxC = timestampMillis;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.zzaVf.getMetadata().zzzS = rotation;
            return this;
        }

        public Frame build() {
            if (this.zzaVf.zzaVe == null && this.zzaVf.mBitmap == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zzaVf;
        }
    }
}

