/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.SystemClock;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.location.LocationRequest;
import java.util.concurrent.TimeUnit;

public class SensorRequest {
    public static final int ACCURACY_MODE_LOW = 1;
    public static final int ACCURACY_MODE_DEFAULT = 2;
    public static final int ACCURACY_MODE_HIGH = 3;
    private final DataSource zzanm;
    private final DataType zzanl;
    private final long zzaoE;
    private final long zzaqm;
    private final long zzaql;
    private final int zzaoF;
    private final LocationRequest zzaqq;
    private final long zzaqr;

    private SensorRequest(Builder builder) {
        this.zzanm = builder.zzanm;
        this.zzanl = builder.zzanl;
        this.zzaoE = builder.zzaoE;
        this.zzaqm = builder.zzaqm;
        this.zzaql = builder.zzaql;
        this.zzaoF = builder.zzaoF;
        this.zzaqq = null;
        this.zzaqr = builder.zzaqr;
    }

    private SensorRequest(DataSource dataSource, LocationRequest locationRequest) {
        this.zzaqq = locationRequest;
        this.zzaoE = TimeUnit.MILLISECONDS.toMicros(locationRequest.getInterval());
        this.zzaqm = TimeUnit.MILLISECONDS.toMicros(locationRequest.getFastestInterval());
        this.zzaql = this.zzaoE;
        this.zzanl = dataSource.getDataType();
        this.zzaoF = SensorRequest.zza(locationRequest);
        this.zzanm = dataSource;
        long l = locationRequest.getExpirationTime();
        this.zzaqr = l == Long.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.MILLISECONDS.toMicros(l - SystemClock.elapsedRealtime());
    }

    public static SensorRequest fromLocationRequest(DataSource dataSource, LocationRequest locationRequest) {
        return new SensorRequest(dataSource, locationRequest);
    }

    private static int zza(LocationRequest locationRequest) {
        switch (locationRequest.getPriority()) {
            case 100: {
                return 3;
            }
            case 104: {
                return 1;
            }
        }
        return 2;
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public DataType getDataType() {
        return this.zzanl;
    }

    public long getSamplingRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaoE, TimeUnit.MICROSECONDS);
    }

    public long getFastestRate(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaqm, TimeUnit.MICROSECONDS);
    }

    public long getMaxDeliveryLatency(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzaql, TimeUnit.MICROSECONDS);
    }

    public int getAccuracyMode() {
        return this.zzaoF;
    }

    public long zzsu() {
        return this.zzaqr;
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("dataSource", (Object)this.zzanm).zzg("dataType", (Object)this.zzanl).zzg("samplingRateMicros", (Object)this.zzaoE).zzg("deliveryLatencyMicros", (Object)this.zzaql).zzg("timeOutMicros", (Object)this.zzaqr).toString();
    }

    public boolean equals(Object that) {
        return this == that || that instanceof SensorRequest && this.zza((SensorRequest)that);
    }

    private boolean zza(SensorRequest sensorRequest) {
        return zzw.equal((Object)this.zzanm, (Object)sensorRequest.zzanm) && zzw.equal((Object)this.zzanl, (Object)sensorRequest.zzanl) && this.zzaoE == sensorRequest.zzaoE && this.zzaqm == sensorRequest.zzaqm && this.zzaql == sensorRequest.zzaql && this.zzaoF == sensorRequest.zzaoF && zzw.equal((Object)this.zzaqq, (Object)sensorRequest.zzaqq) && this.zzaqr == sensorRequest.zzaqr;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm, this.zzanl, this.zzaoE, this.zzaqm, this.zzaql, this.zzaoF, this.zzaqq, this.zzaqr});
    }

    public static int zzeW(int n) {
        switch (n) {
            case 1: 
            case 3: {
                return n;
            }
        }
        return 2;
    }

    public static class Builder {
        private DataSource zzanm;
        private DataType zzanl;
        private long zzaoE = -1L;
        private long zzaqm = 0L;
        private long zzaql = 0L;
        private boolean zzaqs = false;
        private int zzaoF = 2;
        private long zzaqr = Long.MAX_VALUE;

        public Builder setDataSource(DataSource dataSource) {
            this.zzanm = dataSource;
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.zzanl = dataType;
            return this;
        }

        public Builder setSamplingRate(long interval, TimeUnit unit) {
            zzx.zzb((interval >= 0L ? 1 : 0) != 0, (Object)"Cannot use a negative sampling interval");
            this.zzaoE = unit.toMicros(interval);
            if (!this.zzaqs) {
                this.zzaqm = this.zzaoE / 2L;
            }
            return this;
        }

        public Builder setFastestRate(int fastestInterval, TimeUnit unit) {
            zzx.zzb((fastestInterval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative interval");
            this.zzaqs = true;
            this.zzaqm = unit.toMicros(fastestInterval);
            return this;
        }

        public Builder setMaxDeliveryLatency(int interval, TimeUnit unit) {
            zzx.zzb((interval >= 0 ? 1 : 0) != 0, (Object)"Cannot use a negative delivery interval");
            this.zzaql = unit.toMicros(interval);
            return this;
        }

        public Builder setAccuracyMode(int accuracyMode) {
            this.zzaoF = SensorRequest.zzeW(accuracyMode);
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            zzx.zzb((timeout > 0L ? 1 : 0) != 0, (String)"Invalid time out value specified: %d", (Object[])new Object[]{timeout});
            zzx.zzb((timeUnit != null ? 1 : 0) != 0, (Object)"Invalid time unit specified");
            this.zzaqr = timeUnit.toMicros(timeout);
            return this;
        }

        public SensorRequest build() {
            zzx.zza((this.zzanm != null || this.zzanl != null ? 1 : 0) != 0, (Object)"Must call setDataSource() or setDataType()");
            zzx.zza((this.zzanl == null || this.zzanm == null || this.zzanl.equals(this.zzanm.getDataType()) ? 1 : 0) != 0, (Object)"Specified data type is incompatible with specified data source");
            return new SensorRequest(this);
        }
    }
}

