/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.request;

import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Session;
import com.google.android.gms.fitness.request.zzd;
import com.google.android.gms.internal.zznh;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DataDeleteRequest
implements SafeParcelable {
    private final int mVersionCode;
    private final long zzMS;
    private final long zzann;
    private final List<DataSource> zzapG;
    private final List<DataType> zzanw;
    private final List<Session> zzapH;
    private final boolean zzapI;
    private final boolean zzapJ;
    private final zznh zzapE;
    private final String zzOZ;
    public static final Parcelable.Creator<DataDeleteRequest> CREATOR = new zzd();

    DataDeleteRequest(int versionCode, long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, IBinder callback, String packageName) {
        this.mVersionCode = versionCode;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapH = sessions;
        this.zzapI = deleteAllData;
        this.zzapJ = deleteAllSessions;
        this.zzapE = callback == null ? null : zznh.zza.zzbJ(callback);
        this.zzOZ = packageName;
    }

    private DataDeleteRequest(Builder builder) {
        this(builder.zzMS, builder.zzann, builder.zzapG, builder.zzanw, builder.zzapH, builder.zzapI, builder.zzapJ, null, null);
    }

    public DataDeleteRequest(DataDeleteRequest request, zznh callback, String packageName) {
        this(request.zzMS, request.zzann, request.zzapG, request.zzanw, request.zzapH, request.zzapI, request.zzapJ, callback, packageName);
    }

    public DataDeleteRequest(long startTimeMillis, long endTimeMillis, List<DataSource> dataSources, List<DataType> dataTypes, List<Session> sessions, boolean deleteAllData, boolean deleteAllSessions, zznh callback, String packageName) {
        this.mVersionCode = 2;
        this.zzMS = startTimeMillis;
        this.zzann = endTimeMillis;
        this.zzapG = Collections.unmodifiableList(dataSources);
        this.zzanw = Collections.unmodifiableList(dataTypes);
        this.zzapH = sessions;
        this.zzapI = deleteAllData;
        this.zzapJ = deleteAllSessions;
        this.zzapE = callback;
        this.zzOZ = packageName;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzMS, TimeUnit.MILLISECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzann, TimeUnit.MILLISECONDS);
    }

    public List<DataSource> getDataSources() {
        return this.zzapG;
    }

    public List<DataType> getDataTypes() {
        return this.zzanw;
    }

    public List<Session> getSessions() {
        return this.zzapH;
    }

    public boolean deleteAllData() {
        return this.zzapI;
    }

    public boolean deleteAllSessions() {
        return this.zzapJ;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof DataDeleteRequest && this.zzb((DataDeleteRequest)o);
    }

    private boolean zzb(DataDeleteRequest dataDeleteRequest) {
        return this.zzMS == dataDeleteRequest.zzMS && this.zzann == dataDeleteRequest.zzann && zzw.equal(this.zzapG, dataDeleteRequest.zzapG) && zzw.equal(this.zzanw, dataDeleteRequest.zzanw) && zzw.equal(this.zzapH, dataDeleteRequest.zzapH) && this.zzapI == dataDeleteRequest.zzapI && this.zzapJ == dataDeleteRequest.zzapJ;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzMS, this.zzann});
    }

    public String toString() {
        return zzw.zzu((Object)this).zzg("startTimeMillis", (Object)this.zzMS).zzg("endTimeMillis", (Object)this.zzann).zzg("dataSources", this.zzapG).zzg("dateTypes", this.zzanw).zzg("sessions", this.zzapH).zzg("deleteAllData", (Object)this.zzapI).zzg("deleteAllSessions", (Object)this.zzapJ).toString();
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean zzsd() {
        return this.zzapI;
    }

    public boolean zzse() {
        return this.zzapJ;
    }

    public long zzrw() {
        return this.zzann;
    }

    public long zzkH() {
        return this.zzMS;
    }

    public IBinder zzsc() {
        return this.zzapE == null ? null : this.zzapE.asBinder();
    }

    public String getPackageName() {
        return this.zzOZ;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzd.zza(this, dest, flags);
    }

    public static class Builder {
        private long zzMS;
        private long zzann;
        private List<DataSource> zzapG = new ArrayList<DataSource>();
        private List<DataType> zzanw = new ArrayList<DataType>();
        private List<Session> zzapH = new ArrayList<Session>();
        private boolean zzapI = false;
        private boolean zzapJ = false;

        public Builder setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
            zzx.zzb((startTime > 0L ? 1 : 0) != 0, (String)"Invalid start time :%d", (Object[])new Object[]{startTime});
            zzx.zzb((endTime > startTime ? 1 : 0) != 0, (String)"Invalid end time :%d", (Object[])new Object[]{endTime});
            this.zzMS = timeUnit.toMillis(startTime);
            this.zzann = timeUnit.toMillis(endTime);
            return this;
        }

        public Builder deleteAllData() {
            zzx.zzb((boolean)this.zzanw.isEmpty(), (Object)"Specific data type already added for deletion. deleteAllData() will delete all data types and cannot be combined with addDataType()");
            zzx.zzb((boolean)this.zzapG.isEmpty(), (Object)"Specific data source already added for deletion. deleteAllData() will delete all data sources and cannot be combined with addDataSource()");
            this.zzapI = true;
            return this;
        }

        public Builder addDataType(DataType dataType) {
            zzx.zzb((!this.zzapI ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataType() cannot be combined with deleteAllData()");
            zzx.zzb((dataType != null ? 1 : 0) != 0, (Object)"Must specify a valid data type");
            if (!this.zzanw.contains(dataType)) {
                this.zzanw.add(dataType);
            }
            return this;
        }

        public Builder addDataSource(DataSource dataSource) {
            zzx.zzb((!this.zzapI ? 1 : 0) != 0, (Object)"All data is already marked for deletion.  addDataSource() cannot be combined with deleteAllData()");
            zzx.zzb((dataSource != null ? 1 : 0) != 0, (Object)"Must specify a valid data source");
            if (!this.zzapG.contains(dataSource)) {
                this.zzapG.add(dataSource);
            }
            return this;
        }

        public Builder addSession(Session session) {
            zzx.zzb((!this.zzapJ ? 1 : 0) != 0, (Object)"All sessions already marked for deletion.  addSession() cannot be combined with deleteAllSessions()");
            zzx.zzb((session != null ? 1 : 0) != 0, (Object)"Must specify a valid session");
            zzx.zzb((session.getEndTime(TimeUnit.MILLISECONDS) > 0L ? 1 : 0) != 0, (Object)"Cannot delete an ongoing session. Please stop the session prior to deleting it");
            this.zzapH.add(session);
            return this;
        }

        public Builder deleteAllSessions() {
            zzx.zzb((boolean)this.zzapH.isEmpty(), (Object)"Specific session already added for deletion. deleteAllData() will delete all sessions and cannot be combined with addSession()");
            this.zzapJ = true;
            return this;
        }

        public DataDeleteRequest build() {
            zzx.zza((this.zzMS > 0L && this.zzann > this.zzMS ? 1 : 0) != 0, (Object)"Must specify a valid time interval");
            boolean bl = this.zzapI || !this.zzapG.isEmpty() || !this.zzanw.isEmpty();
            boolean bl2 = this.zzapJ || !this.zzapH.isEmpty();
            zzx.zza((bl || bl2 ? 1 : 0) != 0, (Object)"No data or session marked for deletion");
            this.zzsf();
            return new DataDeleteRequest(this);
        }

        private void zzsf() {
            if (this.zzapH.isEmpty()) {
                return;
            }
            for (Session session : this.zzapH) {
                zzx.zza((session.getStartTime(TimeUnit.MILLISECONDS) >= this.zzMS && session.getEndTime(TimeUnit.MILLISECONDS) <= this.zzann ? 1 : 0) != 0, (String)"Session %s is outside the time interval [%d, %d]", (Object[])new Object[]{session, this.zzMS, this.zzann});
            }
        }
    }
}

