/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fitness.data;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.zzc;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.fitness.data.DataSource;
import com.google.android.gms.fitness.data.DataType;
import com.google.android.gms.fitness.data.Field;
import com.google.android.gms.fitness.data.RawDataPoint;
import com.google.android.gms.fitness.data.Value;
import com.google.android.gms.fitness.data.zzd;
import com.google.android.gms.internal.zzmh;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class DataPoint
implements SafeParcelable {
    private final int mVersionCode;
    private final DataSource zzanm;
    private long zzanB;
    private long zzanC;
    private final Value[] zzanD;
    private DataSource zzanE;
    private long zzanF;
    private long zzanG;
    public static final Parcelable.Creator<DataPoint> CREATOR = new zzd();

    DataPoint(int versionCode, DataSource dataSource, long timestampNanos, long startTimeNanos, Value[] values, DataSource originalDataSource, long rawTimestamp, long insertionTimeMillis) {
        this.mVersionCode = versionCode;
        this.zzanm = dataSource;
        this.zzanE = originalDataSource;
        this.zzanB = timestampNanos;
        this.zzanC = startTimeNanos;
        this.zzanD = values;
        this.zzanF = rawTimestamp;
        this.zzanG = insertionTimeMillis;
    }

    DataPoint(List<DataSource> dataSources, RawDataPoint rawDataPoint) {
        this(DataPoint.zza(dataSources, rawDataPoint.zzaow), DataPoint.zza(dataSources, rawDataPoint.zzaox), rawDataPoint);
    }

    public DataPoint(DataSource dataSource, DataSource originalDataSource, RawDataPoint rawDataPoint) {
        this(4, dataSource, DataPoint.zza(rawDataPoint.zzanB, 0L), DataPoint.zza(rawDataPoint.zzanC, 0L), rawDataPoint.zzanD, originalDataSource, DataPoint.zza(rawDataPoint.zzanF, 0L), DataPoint.zza(rawDataPoint.zzanG, 0L));
    }

    private static DataSource zza(List<DataSource> list, int n) {
        return n >= 0 && n < list.size() ? list.get(n) : null;
    }

    private DataPoint(DataSource dataSource) {
        this.mVersionCode = 4;
        this.zzanm = (DataSource)zzx.zzb((Object)dataSource, (Object)"Data source cannot be null");
        DataType dataType = dataSource.getDataType();
        List<Field> list = dataType.getFields();
        this.zzanD = new Value[list.size()];
        int n = 0;
        for (Field field : list) {
            this.zzanD[n] = new Value(field.getFormat());
            ++n;
        }
    }

    public static DataPoint create(DataSource dataSource) {
        return new DataPoint(dataSource);
    }

    public static DataPoint extract(Intent intent) {
        if (intent == null) {
            return null;
        }
        return (DataPoint)zzc.zza((Intent)intent, (String)"com.google.android.gms.fitness.EXTRA_DATA_POINT", CREATOR);
    }

    public DataPoint setTimestamp(long timestamp, TimeUnit timeUnit) {
        this.zzanB = timeUnit.toNanos(timestamp);
        if (this.zzrx() && zzmh.zza(timeUnit)) {
            Log.w((String)"Fitness", (String)"Storing location at more than millisecond granularity is not supported. Extra precision is lost as the value is converted to milliseconds.");
            this.zzanB = zzmh.zza(this.zzanB, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS);
        }
        return this;
    }

    private boolean zzrx() {
        return this.getDataType() == DataType.TYPE_LOCATION_SAMPLE;
    }

    public DataPoint setTimeInterval(long startTime, long endTime, TimeUnit timeUnit) {
        this.zzanC = timeUnit.toNanos(startTime);
        this.zzanB = timeUnit.toNanos(endTime);
        return this;
    }

    public Value getValue(Field field) {
        int n = this.getDataType().indexOf(field);
        return this.zzanD[n];
    }

    public Value[] zzry() {
        return this.zzanD;
    }

    public DataPoint setFloatValues(float ... values) {
        this.zzen(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzanD[i].setFloat(values[i]);
        }
        return this;
    }

    public DataPoint setIntValues(int ... values) {
        this.zzen(values.length);
        for (int i = 0; i < values.length; ++i) {
            this.zzanD[i].setInt(values[i]);
        }
        return this;
    }

    private void zzen(int n) {
        List<Field> list = this.getDataType().getFields();
        int n2 = list.size();
        zzx.zzb((n == n2 ? 1 : 0) != 0, (String)"Attempting to insert %s values, but needed %s: %s", (Object[])new Object[]{n, n2, list});
    }

    public DataType getDataType() {
        return this.zzanm.getDataType();
    }

    public DataSource getDataSource() {
        return this.zzanm;
    }

    public DataSource getOriginalDataSource() {
        return this.zzanE;
    }

    public long getTimestamp(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzanB, TimeUnit.NANOSECONDS);
    }

    public long zzrz() {
        return this.zzanF;
    }

    public long zzrA() {
        return this.zzanG;
    }

    public long getStartTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzanC, TimeUnit.NANOSECONDS);
    }

    public long getEndTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.zzanB, TimeUnit.NANOSECONDS);
    }

    public void zzrB() {
        DataSource dataSource = this.getDataSource();
        zzx.zzb((boolean)this.getDataType().getName().equals(dataSource.getDataType().getName()), (String)"Conflicting data types found %s vs %s", (Object[])new Object[]{this.getDataType(), this.getDataType()});
        zzx.zzb((this.zzanB > 0L ? 1 : 0) != 0, (String)"Data point does not have the timestamp set: %s", (Object[])new Object[]{this});
        zzx.zzb((this.zzanC <= this.zzanB ? 1 : 0) != 0, (String)"Data point with start time greater than end time found: %s", (Object[])new Object[]{this});
    }

    public boolean equals(Object o) {
        return this == o || o instanceof DataPoint && this.zza((DataPoint)o);
    }

    private boolean zza(DataPoint dataPoint) {
        return zzw.equal((Object)this.zzanm, (Object)dataPoint.zzanm) && this.zzanB == dataPoint.zzanB && this.zzanC == dataPoint.zzanC && Arrays.equals(this.zzanD, dataPoint.zzanD) && zzw.equal((Object)this.zzanE, (Object)dataPoint.zzanE);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzanm, this.zzanB, this.zzanC});
    }

    public String toString() {
        return String.format("DataPoint{%s@[%s, %s,raw=%s,insert=%s](%s %s)}", Arrays.toString(this.zzanD), this.zzanC, this.zzanB, this.zzanF, this.zzanG, this.zzanm.toDebugString(), this.zzanE != null ? this.zzanE.toDebugString() : "N/A");
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public long getTimestampNanos() {
        return this.zzanB;
    }

    public long zzrC() {
        return this.zzanC;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int flags) {
        zzd.zza(this, parcel, flags);
    }

    private static long zza(Long l, long l2) {
        return l != null ? l : l2;
    }
}

