/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zzc;
import com.google.android.gms.common.api.zzl;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzpc;
import com.google.android.gms.nearby.Nearby;
import com.google.android.gms.nearby.connection.AppMetadata;
import com.google.android.gms.nearby.connection.Connections;
import java.util.List;

public final class zzpd
implements Connections {
    public static final Api.zzc<zzpc> zzQf = new Api.zzc();
    public static final Api.zza<zzpc, Api.ApiOptions.NoOptions> zzQg = new Api.zza<zzpc, Api.ApiOptions.NoOptions>(){

        public zzpc zzo(Context context, Looper looper, zzf zzf2, Api.ApiOptions.NoOptions noOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return new zzpc(context, looper, zzf2, connectionCallbacks, onConnectionFailedListener);
        }

        public /* synthetic */ Api.zzb zza(Context context, Looper looper, zzf zzf2, Object object, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            return this.zzo(context, looper, zzf2, (Api.ApiOptions.NoOptions)object, connectionCallbacks, onConnectionFailedListener);
        }
    };

    public static zzpc zzd(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zzb((googleApiClient != null ? 1 : 0) != 0, (Object)"GoogleApiClient parameter is required.");
        zzx.zza((boolean)googleApiClient.isConnected(), (Object)"GoogleApiClient must be connected.");
        return zzpd.zze(googleApiClient, bl);
    }

    public static zzpc zze(GoogleApiClient googleApiClient, boolean bl) {
        zzx.zza((boolean)googleApiClient.zza(Nearby.CONNECTIONS_API), (Object)"GoogleApiClient is not configured to use the Nearby Connections Api. Pass Nearby.CONNECTIONS_API into GoogleApiClient.Builder#addApi() to use this feature.");
        boolean bl2 = googleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API);
        if (bl && !bl2) {
            throw new IllegalStateException("GoogleApiClient has an optional Nearby.CONNECTIONS_API and is not connected to Nearby Connections. Use GoogleApiClient.hasConnectedApi(Nearby.CONNECTIONS_API) to guard this call.");
        }
        return bl2 ? (zzpc)googleApiClient.zza(zzQf) : null;
    }

    @Override
    public String getLocalEndpointId(GoogleApiClient apiClient) {
        return zzpd.zzd(apiClient, true).zzyk();
    }

    @Override
    public String getLocalDeviceId(GoogleApiClient apiClient) {
        return zzpd.zzd(apiClient, true).zzyl();
    }

    @Override
    public PendingResult<Connections.StartAdvertisingResult> startAdvertising(GoogleApiClient apiClient, final String name, final AppMetadata appMetadata, final long durationMillis, Connections.ConnectionRequestListener connectionRequestListener) {
        final zzl zzl2 = apiClient.zzp((Object)connectionRequestListener);
        return apiClient.zzb((zzc.zza)new zzb(apiClient){

            protected void zza(zzpc zzpc2) throws RemoteException {
                zzpc2.zza((zzc.zzb<Connections.StartAdvertisingResult>)this, name, appMetadata, durationMillis, (zzl<Connections.ConnectionRequestListener>)zzl2);
            }
        });
    }

    @Override
    public void stopAdvertising(GoogleApiClient apiClient) {
        zzpd.zzd(apiClient, false).zzym();
    }

    @Override
    public PendingResult<Status> startDiscovery(GoogleApiClient apiClient, final String serviceId, final long durationMillis, Connections.EndpointDiscoveryListener listener) {
        final zzl zzl2 = apiClient.zzp((Object)listener);
        return apiClient.zzb((zzc.zza)new zzc(apiClient){

            protected void zza(zzpc zzpc2) throws RemoteException {
                zzpc2.zza((zzc.zzb<Status>)this, serviceId, durationMillis, (zzl<Connections.EndpointDiscoveryListener>)zzl2);
            }
        });
    }

    @Override
    public void stopDiscovery(GoogleApiClient apiClient, String serviceId) {
        zzpd.zzd(apiClient, false).zzec(serviceId);
    }

    @Override
    public PendingResult<Status> sendConnectionRequest(GoogleApiClient apiClient, final String name, final String remoteEndpointId, final byte[] payload, Connections.ConnectionResponseCallback connectionResponseCallback, Connections.MessageListener messageListener) {
        final zzl zzl2 = apiClient.zzp((Object)connectionResponseCallback);
        final zzl zzl3 = apiClient.zzp((Object)messageListener);
        return apiClient.zzb((zzc.zza)new zzc(apiClient){

            protected void zza(zzpc zzpc2) throws RemoteException {
                zzpc2.zza((zzc.zzb<Status>)this, name, remoteEndpointId, payload, (zzl<Connections.ConnectionResponseCallback>)zzl2, (zzl<Connections.MessageListener>)zzl3);
            }
        });
    }

    @Override
    public PendingResult<Status> acceptConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId, final byte[] payload, Connections.MessageListener messageListener) {
        final zzl zzl2 = apiClient.zzp((Object)messageListener);
        return apiClient.zzb((zzc.zza)new zzc(apiClient){

            protected void zza(zzpc zzpc2) throws RemoteException {
                zzpc2.zza((zzc.zzb<Status>)this, remoteEndpointId, payload, (zzl<Connections.MessageListener>)zzl2);
            }
        });
    }

    @Override
    public PendingResult<Status> rejectConnectionRequest(GoogleApiClient apiClient, final String remoteEndpointId) {
        return apiClient.zzb((zzc.zza)new zzc(apiClient){

            protected void zza(zzpc zzpc2) throws RemoteException {
                zzpc2.zzp((zzc.zzb<Status>)this, remoteEndpointId);
            }
        });
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzpd.zzd(apiClient, false).zza(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendReliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzpd.zzd(apiClient, false).zza(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, String remoteEndpointId, byte[] payload) {
        zzpd.zzd(apiClient, false).zzb(new String[]{remoteEndpointId}, payload);
    }

    @Override
    public void sendUnreliableMessage(GoogleApiClient apiClient, List<String> remoteEndpointIds, byte[] payload) {
        zzpd.zzd(apiClient, false).zzb(remoteEndpointIds.toArray(new String[remoteEndpointIds.size()]), payload);
    }

    @Override
    public void disconnectFromEndpoint(GoogleApiClient apiClient, String remoteEndpointId) {
        zzpd.zzd(apiClient, false).zzed(remoteEndpointId);
    }

    @Override
    public void stopAllEndpoints(GoogleApiClient apiClient) {
        zzpd.zzd(apiClient, false).zzyn();
    }

    private static abstract class zzc
    extends zza<Status> {
        private zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Status zzd(Status status) {
            return status;
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzd(status);
        }
    }

    private static abstract class zzb
    extends zza<Connections.StartAdvertisingResult> {
        private zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public Connections.StartAdvertisingResult zzaV(final Status status) {
            return new Connections.StartAdvertisingResult(){

                @Override
                public String getLocalEndpointName() {
                    return null;
                }

                public Status getStatus() {
                    return status;
                }
            };
        }

        public /* synthetic */ Result zzb(Status status) {
            return this.zzaV(status);
        }
    }

    private static abstract class zza<R extends Result>
    extends zzc.zza<R, zzpc> {
        public zza(GoogleApiClient googleApiClient) {
            super(zzQf, googleApiClient);
        }
    }
}

