/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.events;

import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.events.ResourceEvent;
import com.google.android.gms.drive.events.zze;
import com.google.android.gms.drive.internal.zzao;
import com.google.android.gms.drive.internal.zzy;
import com.google.android.gms.drive.metadata.internal.MetadataBundle;
import com.google.android.gms.internal.zzlr;
import com.google.android.gms.internal.zzmb;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class CompletionEvent
implements SafeParcelable,
ResourceEvent {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_CONFLICT = 2;
    public static final int STATUS_CANCELED = 3;
    public static final Parcelable.Creator<CompletionEvent> CREATOR = new zze();
    final int mVersionCode;
    final DriveId zzags;
    final String zzQE;
    final ParcelFileDescriptor zzahs;
    final ParcelFileDescriptor zzaht;
    final MetadataBundle zzahu;
    final List<String> zzahv;
    final int zzxJ;
    final IBinder zzahw;
    private boolean zzahx = false;
    private boolean zzahy = false;
    private boolean zzahz = false;

    CompletionEvent(int versionCode, DriveId driveId, String accountName, ParcelFileDescriptor baseParcelFileDescriptor, ParcelFileDescriptor modifiedParcelFileDescriptor, MetadataBundle modifiedMetadataBundle, List<String> trackingTags, int status, IBinder releaseCallback) {
        this.mVersionCode = versionCode;
        this.zzags = driveId;
        this.zzQE = accountName;
        this.zzahs = baseParcelFileDescriptor;
        this.zzaht = modifiedParcelFileDescriptor;
        this.zzahu = modifiedMetadataBundle;
        this.zzahv = trackingTags;
        this.zzxJ = status;
        this.zzahw = releaseCallback;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zze.zza(this, dest, flags | 1);
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public DriveId getDriveId() {
        this.zzqx();
        return this.zzags;
    }

    public String getAccountName() {
        this.zzqx();
        return this.zzQE;
    }

    public InputStream getBaseContentsInputStream() {
        this.zzqx();
        if (this.zzahs == null) {
            return null;
        }
        if (this.zzahx) {
            throw new IllegalStateException("getBaseInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzahx = true;
        return new FileInputStream(this.zzahs.getFileDescriptor());
    }

    public InputStream getModifiedContentsInputStream() {
        this.zzqx();
        if (this.zzaht == null) {
            return null;
        }
        if (this.zzahy) {
            throw new IllegalStateException("getModifiedInputStream() can only be called once per CompletionEvent instance.");
        }
        this.zzahy = true;
        return new FileInputStream(this.zzaht.getFileDescriptor());
    }

    public MetadataChangeSet getModifiedMetadataChangeSet() {
        this.zzqx();
        return this.zzahu != null ? new MetadataChangeSet(this.zzahu) : null;
    }

    public List<String> getTrackingTags() {
        this.zzqx();
        return new ArrayList<String>(this.zzahv);
    }

    public int getStatus() {
        this.zzqx();
        return this.zzxJ;
    }

    public void dismiss() {
        this.zzt(false);
    }

    public void snooze() {
        this.zzt(true);
    }

    private void zzt(boolean bl) {
        this.zzqx();
        this.zzahz = true;
        zzlr.zza((ParcelFileDescriptor)this.zzahs);
        zzlr.zza((ParcelFileDescriptor)this.zzaht);
        if (this.zzahu != null && this.zzahu.zzc(zzmb.zzakT)) {
            this.zzahu.zza(zzmb.zzakT).release();
        }
        if (this.zzahw == null) {
            zzy.zzx("CompletionEvent", "No callback on " + (bl ? "snooze" : "dismiss"));
            return;
        }
        try {
            zzao.zza.zzaV(this.zzahw).zzt(bl);
        }
        catch (RemoteException remoteException) {
            zzy.zzx("CompletionEvent", "RemoteException on " + (bl ? "snooze" : "dismiss") + ": " + (Object)((Object)remoteException));
        }
    }

    private void zzqx() {
        if (this.zzahz) {
            throw new IllegalStateException("Event has already been dismissed or snoozed.");
        }
    }

    public String toString() {
        String string = this.zzahv == null ? "<null>" : "'" + TextUtils.join((CharSequence)"','", this.zzahv) + "'";
        return String.format(Locale.US, "CompletionEvent [id=%s, status=%s, trackingTag=%s]", this.zzags, this.zzxJ, string);
    }
}

