/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.preference;

import android.content.Context;
import android.os.Handler;
import android.support.v7.preference.Preference;
import android.support.v7.preference.PreferenceGroup;
import android.support.v7.preference.PreferenceViewHolder;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.List;

public class PreferenceGroupAdapter
extends RecyclerView.Adapter<PreferenceViewHolder>
implements Preference.OnPreferenceChangeInternalListener {
    private static final String TAG = "PreferenceGroupAdapter";
    private PreferenceGroup mPreferenceGroup;
    private List<Preference> mPreferenceList;
    private List<Preference> mPreferenceListInternal;
    private List<PreferenceLayout> mPreferenceLayouts;
    private PreferenceLayout mTempPreferenceLayout = new PreferenceLayout();
    private volatile boolean mIsSyncing = false;
    private Handler mHandler = new Handler();
    private Runnable mSyncRunnable = new Runnable(){

        @Override
        public void run() {
            PreferenceGroupAdapter.this.syncMyPreferences();
        }
    };

    public PreferenceGroupAdapter(PreferenceGroup preferenceGroup) {
        this.mPreferenceGroup = preferenceGroup;
        this.mPreferenceGroup.setOnPreferenceChangeInternalListener(this);
        this.mPreferenceList = new ArrayList<Preference>();
        this.mPreferenceListInternal = new ArrayList<Preference>();
        this.mPreferenceLayouts = new ArrayList<PreferenceLayout>();
        this.setHasStableIds(true);
        this.syncMyPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncMyPreferences() {
        PreferenceGroupAdapter preferenceGroupAdapter = this;
        synchronized (preferenceGroupAdapter) {
            if (this.mIsSyncing) {
                return;
            }
            this.mIsSyncing = true;
        }
        ArrayList<Preference> newPreferenceList = new ArrayList<Preference>(this.mPreferenceListInternal.size());
        this.flattenPreferenceGroup(newPreferenceList, this.mPreferenceGroup);
        this.mPreferenceListInternal = newPreferenceList;
        this.mPreferenceList = new ArrayList<Preference>(this.mPreferenceListInternal.size());
        for (Preference preference : this.mPreferenceListInternal) {
            if (!preference.isVisible()) continue;
            this.mPreferenceList.add(preference);
        }
        this.notifyDataSetChanged();
        PreferenceGroupAdapter preferenceGroupAdapter2 = this;
        synchronized (preferenceGroupAdapter2) {
            this.mIsSyncing = false;
            this.notifyAll();
        }
    }

    private void flattenPreferenceGroup(List<Preference> preferences, PreferenceGroup group) {
        group.sortPreferences();
        int groupSize = group.getPreferenceCount();
        for (int i = 0; i < groupSize; ++i) {
            PreferenceGroup preferenceAsGroup;
            Preference preference = group.getPreference(i);
            preferences.add(preference);
            this.addPreferenceClassName(preference);
            if (preference instanceof PreferenceGroup && (preferenceAsGroup = (PreferenceGroup)preference).isOnSameScreenAsChildren()) {
                this.flattenPreferenceGroup(preferences, preferenceAsGroup);
            }
            preference.setOnPreferenceChangeInternalListener(this);
        }
    }

    private PreferenceLayout createPreferenceLayout(Preference preference, PreferenceLayout in) {
        PreferenceLayout pl = in != null ? in : new PreferenceLayout();
        pl.name = preference.getClass().getName();
        pl.resId = preference.getLayoutResource();
        pl.widgetResId = preference.getWidgetLayoutResource();
        return pl;
    }

    private void addPreferenceClassName(Preference preference) {
        PreferenceLayout pl = this.createPreferenceLayout(preference, null);
        if (!this.mPreferenceLayouts.contains(pl)) {
            this.mPreferenceLayouts.add(pl);
        }
    }

    public int getItemCount() {
        return this.mPreferenceList.size();
    }

    public Preference getItem(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return null;
        }
        return this.mPreferenceList.get(position);
    }

    public long getItemId(int position) {
        if (position < 0 || position >= this.getItemCount()) {
            return Long.MIN_VALUE;
        }
        return this.getItem(position).getId();
    }

    @Override
    public void onPreferenceChange(Preference preference) {
        this.notifyDataSetChanged();
    }

    @Override
    public void onPreferenceHierarchyChange(Preference preference) {
        this.mHandler.removeCallbacks(this.mSyncRunnable);
        this.mHandler.post(this.mSyncRunnable);
    }

    @Override
    public void onPreferenceVisibilityChange(Preference preference) {
        if (preference.isVisible()) {
            int previousVisibleIndex = -1;
            for (Preference pref : this.mPreferenceListInternal) {
                if (preference.equals(pref)) break;
                if (!pref.isVisible()) continue;
                ++previousVisibleIndex;
            }
            this.mPreferenceList.add(previousVisibleIndex + 1, preference);
            this.notifyItemInserted(previousVisibleIndex + 1);
        } else {
            int removalIndex;
            int listSize = this.mPreferenceList.size();
            for (removalIndex = 0; removalIndex < listSize && !preference.equals(this.mPreferenceList.get(removalIndex)); ++removalIndex) {
            }
            this.mPreferenceList.remove(removalIndex);
            this.notifyItemRemoved(removalIndex);
        }
    }

    public int getItemViewType(int position) {
        Preference preference = this.getItem(position);
        this.mTempPreferenceLayout = this.createPreferenceLayout(preference, this.mTempPreferenceLayout);
        return this.mPreferenceLayouts.indexOf(this.mTempPreferenceLayout);
    }

    public PreferenceViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        PreferenceLayout pl = this.mPreferenceLayouts.get(viewType);
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View view = inflater.inflate(pl.resId, parent, false);
        ViewGroup widgetFrame = (ViewGroup)view.findViewById(16908312);
        if (widgetFrame != null) {
            if (pl.widgetResId != 0) {
                inflater.inflate(pl.widgetResId, widgetFrame);
            } else {
                widgetFrame.setVisibility(8);
            }
        }
        return new PreferenceViewHolder(view);
    }

    public void onBindViewHolder(PreferenceViewHolder holder, int position) {
        Preference preference = this.getItem(position);
        preference.onBindViewHolder(holder);
    }

    private static class PreferenceLayout {
        private int resId;
        private int widgetResId;
        private String name;

        private PreferenceLayout() {
        }

        public boolean equals(Object o) {
            if (!(o instanceof PreferenceLayout)) {
                return false;
            }
            PreferenceLayout other = (PreferenceLayout)o;
            return this.resId == other.resId && this.widgetResId == other.widgetResId && TextUtils.equals((CharSequence)this.name, (CharSequence)other.name);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.resId;
            result = 31 * result + this.widgetResId;
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

