/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.request;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.request.zzl;
import com.google.android.gms.ads.internal.util.client.zzb;
import com.google.android.gms.ads.internal.zzp;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.zzlr;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class LargeParcelTeleporter
implements SafeParcelable {
    public static final Parcelable.Creator<LargeParcelTeleporter> CREATOR = new zzl();
    final int mVersionCode;
    ParcelFileDescriptor zzEo;
    private Parcelable zzEp;
    private boolean zzEq;

    LargeParcelTeleporter(int versionCode, ParcelFileDescriptor parcelFileDescriptor) {
        this.mVersionCode = versionCode;
        this.zzEo = parcelFileDescriptor;
        this.zzEp = null;
        this.zzEq = true;
    }

    public LargeParcelTeleporter(SafeParcelable teleportee) {
        this.mVersionCode = 1;
        this.zzEo = null;
        this.zzEp = teleportee;
        this.zzEq = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzEq) {
            byte[] byArray;
            if (this.zzEo == null) {
                zzb.e("File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzEo));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Could not read from parcel file descriptor", iOException);
            }
            finally {
                zzlr.zzb((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzEp = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzEq = false;
        }
        return (T)((SafeParcelable)this.zzEp);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToParcel(Parcel dest, int flags) {
        if (this.zzEo == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzEp.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzEo = this.zzf(byArray);
        }
        zzl.zza(this, dest, flags);
    }

    protected <T> ParcelFileDescriptor zzf(byte[] byArray) {
        try {
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            Runnable runnable = new Runnable((OutputStream)autoCloseOutputStream, byArray){
                final /* synthetic */ OutputStream zzEr;
                final /* synthetic */ byte[] zzEs;
                {
                    this.zzEr = outputStream;
                    this.zzEs = byArray;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DataOutputStream dataOutputStream = new DataOutputStream(this.zzEr);
                    try {
                        dataOutputStream.writeInt(this.zzEs.length);
                        dataOutputStream.write(this.zzEs);
                    }
                    catch (IOException iOException) {
                        zzb.zzb("Error transporting the ad response", iOException);
                        zzp.zzbA().zzc(iOException, true);
                    }
                    finally {
                        zzlr.zzb((Closeable)dataOutputStream);
                    }
                }
            };
            new Thread(runnable).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzb.zzb("Error transporting the ad response", iOException);
            zzp.zzbA().zzc(iOException, true);
            return null;
        }
    }
}

