/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.achievement;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzb;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.achievement.Achievement;
import com.google.android.gms.games.achievement.AchievementEntityCreator;
import com.google.android.gms.internal.zzln;

public final class AchievementEntity
implements SafeParcelable,
Achievement {
    public static final Parcelable.Creator<AchievementEntity> CREATOR = new AchievementEntityCreator();
    private final int mVersionCode;
    private final String zzarS;
    private final int zzUS;
    private final String mName;
    private final String zzaoB;
    private final Uri zzarT;
    private final String zzarU;
    private final Uri zzarV;
    private final String zzarW;
    private final int zzarX;
    private final String zzarY;
    private final PlayerEntity zzarZ;
    private final int mState;
    private final int zzasa;
    private final String zzasb;
    private final long zzasc;
    private final long zzasd;

    public AchievementEntity(Achievement achievement) {
        this.mVersionCode = 1;
        this.zzarS = achievement.getAchievementId();
        this.zzUS = achievement.getType();
        this.mName = achievement.getName();
        this.zzaoB = achievement.getDescription();
        this.zzarT = achievement.getUnlockedImageUri();
        this.zzarU = achievement.getUnlockedImageUrl();
        this.zzarV = achievement.getRevealedImageUri();
        this.zzarW = achievement.getRevealedImageUrl();
        this.zzarZ = (PlayerEntity)achievement.getPlayer().freeze();
        this.mState = achievement.getState();
        this.zzasc = achievement.getLastUpdatedTimestamp();
        this.zzasd = achievement.getXpValue();
        if (achievement.getType() == 1) {
            this.zzarX = achievement.getTotalSteps();
            this.zzarY = achievement.getFormattedTotalSteps();
            this.zzasa = achievement.getCurrentSteps();
            this.zzasb = achievement.getFormattedCurrentSteps();
        } else {
            this.zzarX = 0;
            this.zzarY = null;
            this.zzasa = 0;
            this.zzasb = null;
        }
        zzb.zzr((Object)this.zzarS);
        zzb.zzr((Object)this.zzaoB);
    }

    AchievementEntity(int versionCode, String achievementId, int type, String name, String description, Uri unlockedImageUri, String unlockedImageUrl, Uri revealedImageUri, String revealedImageUrl, int totalSteps, String formattedTotalSteps, PlayerEntity player, int state, int currentSteps, String formattedCurrentSteps, long lastUpdatedTimestamp, long xpValue) {
        this.mVersionCode = versionCode;
        this.zzarS = achievementId;
        this.zzUS = type;
        this.mName = name;
        this.zzaoB = description;
        this.zzarT = unlockedImageUri;
        this.zzarU = unlockedImageUrl;
        this.zzarV = revealedImageUri;
        this.zzarW = revealedImageUrl;
        this.zzarX = totalSteps;
        this.zzarY = formattedTotalSteps;
        this.zzarZ = player;
        this.mState = state;
        this.zzasa = currentSteps;
        this.zzasb = formattedCurrentSteps;
        this.zzasc = lastUpdatedTimestamp;
        this.zzasd = xpValue;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    @Override
    public String getAchievementId() {
        return this.zzarS;
    }

    @Override
    public int getType() {
        return this.zzUS;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public void getName(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.mName, (CharArrayBuffer)dataOut);
    }

    @Override
    public String getDescription() {
        return this.zzaoB;
    }

    @Override
    public void getDescription(CharArrayBuffer dataOut) {
        zzln.zzb((String)this.zzaoB, (CharArrayBuffer)dataOut);
    }

    @Override
    public Uri getUnlockedImageUri() {
        return this.zzarT;
    }

    @Override
    public String getUnlockedImageUrl() {
        return this.zzarU;
    }

    @Override
    public Uri getRevealedImageUri() {
        return this.zzarV;
    }

    @Override
    public String getRevealedImageUrl() {
        return this.zzarW;
    }

    public int zzsV() {
        return this.zzarX;
    }

    @Override
    public int getTotalSteps() {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzsV();
    }

    @Override
    public String getFormattedTotalSteps() {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzsW();
    }

    public String zzsW() {
        return this.zzarY;
    }

    @Override
    public void getFormattedTotalSteps(CharArrayBuffer dataOut) {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        zzln.zzb((String)this.zzarY, (CharArrayBuffer)dataOut);
    }

    @Override
    public Player getPlayer() {
        return this.zzarZ;
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public int getCurrentSteps() {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzsX();
    }

    public int zzsX() {
        return this.zzasa;
    }

    @Override
    public String getFormattedCurrentSteps() {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        return this.zzsY();
    }

    public String zzsY() {
        return this.zzasb;
    }

    @Override
    public void getFormattedCurrentSteps(CharArrayBuffer dataOut) {
        zzb.zzY((this.getType() == 1 ? 1 : 0) != 0);
        zzln.zzb((String)this.zzasb, (CharArrayBuffer)dataOut);
    }

    @Override
    public long getLastUpdatedTimestamp() {
        return this.zzasc;
    }

    @Override
    public long getXpValue() {
        return this.zzasd;
    }

    public Achievement freeze() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return AchievementEntity.zza(this);
    }

    static int zza(Achievement achievement) {
        int n = 0;
        int n2 = 0;
        if (achievement.getType() == 1) {
            n = achievement.getCurrentSteps();
            n2 = achievement.getTotalSteps();
        }
        return zzw.hashCode((Object[])new Object[]{achievement.getAchievementId(), achievement.getName(), achievement.getType(), achievement.getDescription(), achievement.getXpValue(), achievement.getState(), achievement.getLastUpdatedTimestamp(), achievement.getPlayer(), n, n2});
    }

    public boolean equals(Object obj) {
        return AchievementEntity.zza(this, obj);
    }

    static boolean zza(Achievement achievement, Object object) {
        if (!(object instanceof Achievement)) {
            return false;
        }
        if (achievement == object) {
            return true;
        }
        Achievement achievement2 = (Achievement)object;
        boolean bl = true;
        boolean bl2 = true;
        if (achievement.getType() == 1) {
            bl = zzw.equal((Object)achievement2.getCurrentSteps(), (Object)achievement.getCurrentSteps());
            bl2 = zzw.equal((Object)achievement2.getTotalSteps(), (Object)achievement.getTotalSteps());
        }
        return zzw.equal((Object)achievement2.getAchievementId(), (Object)achievement.getAchievementId()) && zzw.equal((Object)achievement2.getName(), (Object)achievement.getName()) && zzw.equal((Object)achievement2.getType(), (Object)achievement.getType()) && zzw.equal((Object)achievement2.getDescription(), (Object)achievement.getDescription()) && zzw.equal((Object)achievement2.getXpValue(), (Object)achievement.getXpValue()) && zzw.equal((Object)achievement2.getState(), (Object)achievement.getState()) && zzw.equal((Object)achievement2.getLastUpdatedTimestamp(), (Object)achievement.getLastUpdatedTimestamp()) && zzw.equal((Object)achievement2.getPlayer(), (Object)achievement.getPlayer()) && bl && bl2;
    }

    public String toString() {
        return AchievementEntity.zzb(this);
    }

    static String zzb(Achievement achievement) {
        zzw.zza zza2 = zzw.zzu((Object)achievement).zzg("Id", (Object)achievement.getAchievementId()).zzg("Type", (Object)achievement.getType()).zzg("Name", (Object)achievement.getName()).zzg("Description", (Object)achievement.getDescription()).zzg("Player", (Object)achievement.getPlayer()).zzg("State", (Object)achievement.getState());
        if (achievement.getType() == 1) {
            zza2.zzg("CurrentSteps", (Object)achievement.getCurrentSteps());
            zza2.zzg("TotalSteps", (Object)achievement.getTotalSteps());
        }
        return zza2.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        AchievementEntityCreator.zza(this, dest, flags);
    }
}

