/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.graphics.Rect;
import android.os.Build;
import android.support.design.widget.ViewGroupUtilsHoneycomb;
import android.view.View;
import android.view.ViewGroup;

class ViewGroupUtils {
    private static final ViewGroupUtilsImpl IMPL;

    ViewGroupUtils() {
    }

    static void offsetDescendantRect(ViewGroup parent, View descendant, Rect rect) {
        IMPL.offsetDescendantRect(parent, descendant, rect);
    }

    static void getDescendantRect(ViewGroup parent, View descendant, Rect out) {
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        ViewGroupUtils.offsetDescendantRect(parent, descendant, out);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 11 ? new ViewGroupUtilsImplHoneycomb() : new ViewGroupUtilsImplBase();
    }

    private static class ViewGroupUtilsImplHoneycomb
    implements ViewGroupUtilsImpl {
        private ViewGroupUtilsImplHoneycomb() {
        }

        @Override
        public void offsetDescendantRect(ViewGroup parent, View child, Rect rect) {
            ViewGroupUtilsHoneycomb.offsetDescendantRect(parent, child, rect);
        }
    }

    private static class ViewGroupUtilsImplBase
    implements ViewGroupUtilsImpl {
        private ViewGroupUtilsImplBase() {
        }

        @Override
        public void offsetDescendantRect(ViewGroup parent, View child, Rect rect) {
            parent.offsetDescendantRectToMyCoords(child, rect);
        }
    }

    private static interface ViewGroupUtilsImpl {
        public void offsetDescendantRect(ViewGroup var1, View var2, Rect var3);
    }
}

