/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.internal.zzll;
import com.google.android.gms.internal.zzlw;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzb {
    private static final Object zzadT = new Object();
    private static zzb zzafu;
    private final List<String> zzafv;
    private final List<String> zzafw;
    private final List<String> zzafx;
    private final List<String> zzafy;
    private static final ComponentName zzafz;
    private zze zzafA;
    private static Integer zzafB;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzpD() {
        Object object = zzadT;
        synchronized (object) {
            if (zzafu == null) {
                zzafu = new zzb();
            }
        }
        return zzafu;
    }

    private zzb() {
        if (zzb.getLogLevel() == zzd.LOG_LEVEL_OFF) {
            this.zzafv = Collections.EMPTY_LIST;
            this.zzafw = Collections.EMPTY_LIST;
            this.zzafx = Collections.EMPTY_LIST;
            this.zzafy = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzafE.get();
        this.zzafv = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzafF.get();
        this.zzafw = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzafG.get();
        this.zzafx = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzafH.get();
        this.zzafy = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzafA = new zze(1024, zzc.zza.zzafI.get());
    }

    private boolean zzb(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null || com.google.android.gms.common.internal.zzd.zzacF && "com.google.android.gms".equals(componentName.getPackageName())) {
            return false;
        }
        return zzll.zzi(context, componentName.getPackageName());
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zzb(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        boolean bl = context.bindService(intent, serviceConnection, n);
        if (bl) {
            this.zza(context, serviceConnection, string2, intent, 2);
        }
        return bl;
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
        this.zza(context, serviceConnection, null, null, 1);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, serviceConnection, string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, serviceConnection, null, null, 4);
    }

    private void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent, int n) {
        ConnectionEvent connectionEvent;
        if (!com.google.android.gms.common.internal.zzd.zzacF) {
            return;
        }
        String string3 = this.zzb(serviceConnection);
        if (!this.zza(context, string2, intent, string3, n)) {
            return;
        }
        long l = System.currentTimeMillis();
        String string4 = null;
        if ((zzb.getLogLevel() & zzd.zzafM) != 0) {
            string4 = zzlw.zzm(3, 5);
        }
        long l2 = 0L;
        if ((zzb.getLogLevel() & zzd.zzafO) != 0) {
            l2 = Debug.getNativeHeapAllocatedSize();
        }
        if (n == 1 || n == 4) {
            connectionEvent = new ConnectionEvent(l, n, null, null, null, null, string4, string3, SystemClock.elapsedRealtime(), l2);
        } else {
            ServiceInfo serviceInfo = zzb.zzc(context, intent);
            connectionEvent = new ConnectionEvent(l, n, zzlw.zzap(context), string2, serviceInfo.processName, serviceInfo.name, string4, string3, SystemClock.elapsedRealtime(), l2);
        }
        context.startService(new Intent().setComponent(zzafz).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zza(Context context, String string2, Intent intent, String string3, int n) {
        int n2 = zzb.getLogLevel();
        if (n2 == zzd.LOG_LEVEL_OFF || this.zzafA == null) {
            return false;
        }
        if (n == 4 || n == 1) {
            return this.zzafA.zzcz(string3);
        }
        ServiceInfo serviceInfo = zzb.zzc(context, intent);
        if (serviceInfo == null) {
            Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string2, intent.toUri(0)));
            return false;
        }
        String string4 = zzlw.zzap(context);
        String string5 = serviceInfo.processName;
        String string6 = serviceInfo.name;
        if (this.zzafv.contains(string4) || this.zzafw.contains(string2) || this.zzafx.contains(string5) || this.zzafy.contains(string6) || string5.equals(string4) && (n2 & zzd.zzafN) != 0) {
            return false;
        }
        this.zzafA.zzcy(string3);
        return true;
    }

    private static ServiceInfo zzc(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzlw.zzm(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzlw.zzm(3, 20)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf(Process.myPid() << 32 | System.identityHashCode(serviceConnection));
    }

    private static int getLogLevel() {
        if (zzafB == null) {
            try {
                zzafB = zzll.zzjk() ? zzc.zza.zzafD.get() : zzd.LOG_LEVEL_OFF;
            }
            catch (SecurityException securityException) {
                zzafB = zzd.LOG_LEVEL_OFF;
            }
        }
        return zzafB;
    }

    static {
        zzafz = new ComponentName("com.google.android.gms", "com.google.android.gms.common.stats.GmsCoreStatsService");
    }
}

