/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.dynamic.zzg;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int mColor;
    private View zzYB;
    private View.OnClickListener zzYC = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.mColor);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        zzx.zza(buttonSize >= 0 && buttonSize < 3, "Unknown button size %d", buttonSize);
        zzx.zza(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme %s", colorScheme);
        this.mSize = buttonSize;
        this.mColor = colorScheme;
        this.zzah(this.getContext());
    }

    private void zzah(Context context) {
        if (this.zzYB != null) {
            this.removeView(this.zzYB);
        }
        try {
            this.zzYB = zzaa.zzb(context, this.mSize, this.mColor);
        }
        catch (zzg.zza zza2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.zzYB = SignInButton.zza(context, this.mSize, this.mColor);
        }
        this.addView(this.zzYB);
        this.zzYB.setEnabled(this.isEnabled());
        this.zzYB.setOnClickListener((View.OnClickListener)this);
    }

    private static Button zza(Context context, int n, int n2) {
        zzab zzab2 = new zzab(context);
        zzab2.zza(context.getResources(), n, n2);
        return zzab2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.zzYC = listener;
        if (this.zzYB != null) {
            this.zzYB.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.zzYB.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.zzYC != null && view == this.zzYB) {
            this.zzYC.onClick((View)this);
        }
    }
}

