/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.zzab;
import com.google.android.gms.analytics.internal.zzac;
import com.google.android.gms.analytics.internal.zzaj;
import com.google.android.gms.analytics.internal.zzd;
import com.google.android.gms.analytics.internal.zzf;
import com.google.android.gms.analytics.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.stats.zzb;
import java.util.Collections;
import java.util.List;

public class zzi
extends zzd {
    private final zza zzLW;
    private zzac zzLX;
    private final zzt zzLY;
    private zzaj zzLZ;

    protected zzi(zzf zzf2) {
        super(zzf2);
        this.zzLZ = new zzaj(zzf2.zzid());
        this.zzLW = new zza();
        this.zzLY = new zzt(zzf2){

            @Override
            public void run() {
                zzi.this.zziC();
            }
        };
    }

    @Override
    protected void zzhB() {
    }

    public boolean isConnected() {
        this.zzic();
        this.zzio();
        return this.zzLX != null;
    }

    public boolean zzb(zzab zzab2) {
        zzx.zzv((Object)zzab2);
        this.zzic();
        this.zzio();
        zzac zzac2 = this.zzLX;
        if (zzac2 == null) {
            return false;
        }
        String string = zzab2.zzkm() ? this.zzif().zzjy() : this.zzif().zzjz();
        List<Command> list = Collections.emptyList();
        try {
            zzac2.zza(zzab2.zzn(), zzab2.zzkk(), string, list);
            this.zziB();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaY("Failed to send hits to AnalyticsService");
            return false;
        }
    }

    public boolean zziA() {
        this.zzic();
        this.zzio();
        zzac zzac2 = this.zzLX;
        if (zzac2 == null) {
            return false;
        }
        try {
            zzac2.zzhU();
            this.zziB();
            return true;
        }
        catch (RemoteException remoteException) {
            this.zzaY("Failed to clear hits from AnalyticsService");
            return false;
        }
    }

    private void zziB() {
        this.zzLZ.start();
        this.zzLY.zzt(this.zzif().zzjF());
    }

    public boolean connect() {
        this.zzic();
        this.zzio();
        if (this.zzLX != null) {
            return true;
        }
        zzac zzac2 = this.zzLW.zziD();
        if (zzac2 != null) {
            this.zzLX = zzac2;
            this.zziB();
            return true;
        }
        return false;
    }

    private void zza(zzac zzac2) {
        this.zzic();
        this.zzLX = zzac2;
        this.zziB();
        this.zzhz().onServiceConnected();
    }

    public void disconnect() {
        this.zzic();
        this.zzio();
        try {
            zzb zzb2 = zzb.zzpD();
            zzb2.zza(this.getContext(), (ServiceConnection)this.zzLW);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.zzLX != null) {
            this.zzLX = null;
            this.onDisconnect();
        }
    }

    private void onServiceDisconnected(ComponentName name) {
        this.zzic();
        if (this.zzLX != null) {
            this.zzLX = null;
            this.zza("Disconnected from device AnalyticsService", name);
            this.onDisconnect();
        }
    }

    private void zziC() {
        this.zzic();
        if (!this.isConnected()) {
            return;
        }
        this.zzaY("Inactivity, disconnecting from device AnalyticsService");
        this.disconnect();
    }

    private void onDisconnect() {
        this.zzhz().zzhX();
    }

    protected class zza
    implements ServiceConnection {
        private volatile zzac zzMb;
        private volatile boolean zzMc;

        protected zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public zzac zziD() {
            zzi.this.zzic();
            Intent intent = new Intent("com.google.android.gms.analytics.service.START");
            intent.setComponent(new ComponentName("com.google.android.gms", "com.google.android.gms.analytics.service.AnalyticsService"));
            Context context = zzi.this.getContext();
            intent.putExtra("app_package_name", context.getPackageName());
            zzb zzb2 = zzb.zzpD();
            zza zza2 = this;
            synchronized (zza2) {
                this.zzMb = null;
                this.zzMc = true;
                boolean bl = zzb2.zza(context, intent, (ServiceConnection)zzi.this.zzLW, 129);
                zzi.this.zza("Bind to service requested", bl);
                if (!bl) {
                    this.zzMc = false;
                    return null;
                }
                try {
                    long l = zzi.this.zzif().zzjG();
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    zzi.this.zzbb("Wait for service connect was interrupted");
                }
                this.zzMc = false;
                zzac zzac2 = this.zzMb;
                this.zzMb = null;
                if (zzac2 == null) {
                    zzi.this.zzbc("Successfully bound to service but never got onServiceConnected callback");
                }
                return zzac2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName name, IBinder binder) {
            zzx.zzch((String)"AnalyticsServiceConnection.onServiceConnected");
            zza zza2 = this;
            synchronized (zza2) {
                try {
                    Object object;
                    if (binder == null) {
                        zzi.this.zzbc("Service connected with null binder");
                        return;
                    }
                    zzac zzac2 = null;
                    try {
                        object = binder.getInterfaceDescriptor();
                        if ("com.google.android.gms.analytics.internal.IAnalyticsService".equals(object)) {
                            zzac2 = zzac.zza.zzae(binder);
                            zzi.this.zzaY("Bound to IAnalyticsService interface");
                        } else {
                            zzi.this.zze("Got binder with a wrong descriptor", object);
                        }
                    }
                    catch (RemoteException remoteException) {
                        zzi.this.zzbc("Service connect failed to get IAnalyticsService");
                    }
                    if (zzac2 == null) {
                        try {
                            zzb.zzpD().zza(zzi.this.getContext(), (ServiceConnection)zzi.this.zzLW);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    } else if (!this.zzMc) {
                        zzi.this.zzbb("onServiceConnected received after the timeout limit");
                        object = zzac2;
                        zzi.this.zzig().zzf(new Runnable((zzac)object){
                            final /* synthetic */ zzac zzMd;
                            {
                                this.zzMd = zzac2;
                            }

                            @Override
                            public void run() {
                                if (!zzi.this.isConnected()) {
                                    zzi.this.zzaZ("Connected to service after a timeout");
                                    zzi.this.zza(this.zzMd);
                                }
                            }
                        });
                    } else {
                        this.zzMb = zzac2;
                    }
                }
                finally {
                    this.notifyAll();
                }
            }
        }

        public void onServiceDisconnected(final ComponentName name) {
            zzx.zzch((String)"AnalyticsServiceConnection.onServiceDisconnected");
            zzi.this.zzig().zzf(new Runnable(){

                @Override
                public void run() {
                    zzi.this.onServiceDisconnected(name);
                }
            });
        }
    }
}

