/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.nearby.messages;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.nearby.messages.zza;
import java.util.Arrays;

public class Message
implements SafeParcelable {
    public static final int MAX_CONTENT_SIZE_BYTES = 102400;
    public static final int MAX_TYPE_LENGTH = 32;
    public static final Parcelable.Creator<Message> CREATOR = new zza();
    final int versionCode;
    private final byte[] content;
    private final String type;
    private final String zzaeI;

    Message(int versionCode, byte[] content, String namespace, String type) {
        this.versionCode = versionCode;
        this.content = (byte[])zzx.zzv((Object)content);
        this.type = (String)zzx.zzv((Object)type);
        this.zzaeI = namespace == null ? "" : namespace;
        zzx.zzb((content.length <= 102400 ? 1 : 0) != 0, (String)"Content length(%d) must not exceed MAX_CONTENT_SIZE_BYTES(%d)", (Object[])new Object[]{content.length, 102400});
        zzx.zzb((type.length() <= 32 ? 1 : 0) != 0, (String)"Type length(%d) must not exceed MAX_TYPE_LENGTH(%d)", (Object[])new Object[]{type.length(), 32});
    }

    public Message(byte[] content) {
        this(content, "", "");
    }

    public Message(byte[] content, String type) {
        this(1, content, "", type);
    }

    Message(byte[] content, String namespace, String type) {
        this(1, content, namespace, type);
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.zzaeI;
    }

    public byte[] getContent() {
        return this.content;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zza.zza(this, out, flags);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzaeI, this.type, Arrays.hashCode(this.content)});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Message)) {
            return false;
        }
        Message message = (Message)object;
        return TextUtils.equals((CharSequence)this.zzaeI, (CharSequence)message.zzaeI) && TextUtils.equals((CharSequence)this.type, (CharSequence)message.type) && Arrays.equals(this.content, message.content);
    }

    public String toString() {
        return "Message{namespace='" + this.zzaeI + "'" + ", type='" + this.type + "'" + ", content=[" + this.content.length + " bytes]" + "}";
    }
}

