/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.accessibility.CaptioningManager;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzls;
import com.google.android.gms.internal.zzlv;
import org.json.JSONException;
import org.json.JSONObject;

public final class TextTrackStyle {
    public static final float DEFAULT_FONT_SCALE = 1.0f;
    public static final int COLOR_UNSPECIFIED = 0;
    public static final int EDGE_TYPE_UNSPECIFIED = -1;
    public static final int EDGE_TYPE_NONE = 0;
    public static final int EDGE_TYPE_OUTLINE = 1;
    public static final int EDGE_TYPE_DROP_SHADOW = 2;
    public static final int EDGE_TYPE_RAISED = 3;
    public static final int EDGE_TYPE_DEPRESSED = 4;
    public static final int WINDOW_TYPE_UNSPECIFIED = -1;
    public static final int WINDOW_TYPE_NONE = 0;
    public static final int WINDOW_TYPE_NORMAL = 1;
    public static final int WINDOW_TYPE_ROUNDED = 2;
    public static final int FONT_FAMILY_UNSPECIFIED = -1;
    public static final int FONT_FAMILY_SANS_SERIF = 0;
    public static final int FONT_FAMILY_MONOSPACED_SANS_SERIF = 1;
    public static final int FONT_FAMILY_SERIF = 2;
    public static final int FONT_FAMILY_MONOSPACED_SERIF = 3;
    public static final int FONT_FAMILY_CASUAL = 4;
    public static final int FONT_FAMILY_CURSIVE = 5;
    public static final int FONT_FAMILY_SMALL_CAPITALS = 6;
    public static final int FONT_STYLE_UNSPECIFIED = -1;
    public static final int FONT_STYLE_NORMAL = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLD_ITALIC = 3;
    private float zzVE;
    private int zzVF;
    private int zzvF;
    private int zzVG;
    private int zzVH;
    private int zzVI;
    private int zzVJ;
    private int zzVK;
    private String zzVL;
    private int zzVM;
    private int zzVN;
    private JSONObject zzUl;

    public TextTrackStyle() {
        this.clear();
    }

    public void setFontScale(float fontScale) {
        this.zzVE = fontScale;
    }

    public float getFontScale() {
        return this.zzVE;
    }

    public void setForegroundColor(int foregroundColor) {
        this.zzVF = foregroundColor;
    }

    public int getForegroundColor() {
        return this.zzVF;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.zzvF = backgroundColor;
    }

    public int getBackgroundColor() {
        return this.zzvF;
    }

    public void setEdgeType(int edgeType) {
        if (edgeType < 0 || edgeType > 4) {
            throw new IllegalArgumentException("invalid edgeType");
        }
        this.zzVG = edgeType;
    }

    public int getEdgeType() {
        return this.zzVG;
    }

    public void setEdgeColor(int edgeColor) {
        this.zzVH = edgeColor;
    }

    public int getEdgeColor() {
        return this.zzVH;
    }

    public void setWindowType(int windowType) {
        if (windowType < 0 || windowType > 2) {
            throw new IllegalArgumentException("invalid windowType");
        }
        this.zzVI = windowType;
    }

    public int getWindowType() {
        return this.zzVI;
    }

    public void setWindowColor(int windowColor) {
        this.zzVJ = windowColor;
    }

    public int getWindowColor() {
        return this.zzVJ;
    }

    public void setWindowCornerRadius(int windowCornerRadius) {
        if (windowCornerRadius < 0) {
            throw new IllegalArgumentException("invalid windowCornerRadius");
        }
        this.zzVK = windowCornerRadius;
    }

    public int getWindowCornerRadius() {
        return this.zzVK;
    }

    public void setFontFamily(String fontFamily) {
        this.zzVL = fontFamily;
    }

    public String getFontFamily() {
        return this.zzVL;
    }

    public void setFontGenericFamily(int fontGenericFamily) {
        if (fontGenericFamily < 0 || fontGenericFamily > 6) {
            throw new IllegalArgumentException("invalid fontGenericFamily");
        }
        this.zzVM = fontGenericFamily;
    }

    public int getFontGenericFamily() {
        return this.zzVM;
    }

    public void setFontStyle(int fontStyle) {
        if (fontStyle < 0 || fontStyle > 3) {
            throw new IllegalArgumentException("invalid fontStyle");
        }
        this.zzVN = fontStyle;
    }

    public int getFontStyle() {
        return this.zzVN;
    }

    public void setCustomData(JSONObject customData) {
        this.zzUl = customData;
    }

    public JSONObject getCustomData() {
        return this.zzUl;
    }

    private void clear() {
        this.zzVE = 1.0f;
        this.zzVF = 0;
        this.zzvF = 0;
        this.zzVG = -1;
        this.zzVH = 0;
        this.zzVI = -1;
        this.zzVJ = 0;
        this.zzVK = 0;
        this.zzVL = null;
        this.zzVM = -1;
        this.zzVN = -1;
        this.zzUl = null;
    }

    public static TextTrackStyle fromSystemSettings(Context context) {
        TextTrackStyle textTrackStyle = new TextTrackStyle();
        if (!zzlv.zzpV()) {
            return textTrackStyle;
        }
        CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
        textTrackStyle.setFontScale(captioningManager.getFontScale());
        CaptioningManager.CaptionStyle captionStyle = captioningManager.getUserStyle();
        textTrackStyle.setBackgroundColor(captionStyle.backgroundColor);
        textTrackStyle.setForegroundColor(captionStyle.foregroundColor);
        switch (captionStyle.edgeType) {
            case 1: {
                textTrackStyle.setEdgeType(1);
                break;
            }
            case 2: {
                textTrackStyle.setEdgeType(2);
                break;
            }
            default: {
                textTrackStyle.setEdgeType(0);
            }
        }
        textTrackStyle.setEdgeColor(captionStyle.edgeColor);
        Typeface typeface = captionStyle.getTypeface();
        if (typeface != null) {
            if (Typeface.MONOSPACE.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(1);
            } else if (Typeface.SANS_SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(0);
            } else if (Typeface.SERIF.equals((Object)typeface)) {
                textTrackStyle.setFontGenericFamily(2);
            } else {
                textTrackStyle.setFontGenericFamily(0);
            }
            boolean bl = typeface.isBold();
            boolean bl2 = typeface.isItalic();
            if (bl && bl2) {
                textTrackStyle.setFontStyle(3);
            } else if (bl) {
                textTrackStyle.setFontStyle(1);
            } else if (bl2) {
                textTrackStyle.setFontStyle(2);
            } else {
                textTrackStyle.setFontStyle(0);
            }
        }
        return textTrackStyle;
    }

    public void zzf(JSONObject jSONObject) throws JSONException {
        String string;
        this.clear();
        this.zzVE = (float)jSONObject.optDouble("fontScale", 1.0);
        this.zzVF = this.zzbH(jSONObject.optString("foregroundColor"));
        this.zzvF = this.zzbH(jSONObject.optString("backgroundColor"));
        if (jSONObject.has("edgeType")) {
            string = jSONObject.getString("edgeType");
            if ("NONE".equals(string)) {
                this.zzVG = 0;
            } else if ("OUTLINE".equals(string)) {
                this.zzVG = 1;
            } else if ("DROP_SHADOW".equals(string)) {
                this.zzVG = 2;
            } else if ("RAISED".equals(string)) {
                this.zzVG = 3;
            } else if ("DEPRESSED".equals(string)) {
                this.zzVG = 4;
            }
        }
        this.zzVH = this.zzbH(jSONObject.optString("edgeColor"));
        if (jSONObject.has("windowType")) {
            string = jSONObject.getString("windowType");
            if ("NONE".equals(string)) {
                this.zzVI = 0;
            } else if ("NORMAL".equals(string)) {
                this.zzVI = 1;
            } else if ("ROUNDED_CORNERS".equals(string)) {
                this.zzVI = 2;
            }
        }
        this.zzVJ = this.zzbH(jSONObject.optString("windowColor"));
        if (this.zzVI == 2) {
            this.zzVK = jSONObject.optInt("windowRoundedCornerRadius", 0);
        }
        this.zzVL = jSONObject.optString("fontFamily", null);
        if (jSONObject.has("fontGenericFamily")) {
            string = jSONObject.getString("fontGenericFamily");
            if ("SANS_SERIF".equals(string)) {
                this.zzVM = 0;
            } else if ("MONOSPACED_SANS_SERIF".equals(string)) {
                this.zzVM = 1;
            } else if ("SERIF".equals(string)) {
                this.zzVM = 2;
            } else if ("MONOSPACED_SERIF".equals(string)) {
                this.zzVM = 3;
            } else if ("CASUAL".equals(string)) {
                this.zzVM = 4;
            } else if ("CURSIVE".equals(string)) {
                this.zzVM = 5;
            } else if ("SMALL_CAPITALS".equals(string)) {
                this.zzVM = 6;
            }
        }
        if (jSONObject.has("fontStyle")) {
            string = jSONObject.getString("fontStyle");
            if ("NORMAL".equals(string)) {
                this.zzVN = 0;
            } else if ("BOLD".equals(string)) {
                this.zzVN = 1;
            } else if ("ITALIC".equals(string)) {
                this.zzVN = 2;
            } else if ("BOLD_ITALIC".equals(string)) {
                this.zzVN = 3;
            }
        }
        this.zzUl = jSONObject.optJSONObject("customData");
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("fontScale", (double)this.zzVE);
            if (this.zzVF != 0) {
                jSONObject.put("foregroundColor", (Object)this.zzH(this.zzVF));
            }
            if (this.zzvF != 0) {
                jSONObject.put("backgroundColor", (Object)this.zzH(this.zzvF));
            }
            switch (this.zzVG) {
                case 0: {
                    jSONObject.put("edgeType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("edgeType", (Object)"OUTLINE");
                    break;
                }
                case 2: {
                    jSONObject.put("edgeType", (Object)"DROP_SHADOW");
                    break;
                }
                case 3: {
                    jSONObject.put("edgeType", (Object)"RAISED");
                    break;
                }
                case 4: {
                    jSONObject.put("edgeType", (Object)"DEPRESSED");
                    break;
                }
            }
            if (this.zzVH != 0) {
                jSONObject.put("edgeColor", (Object)this.zzH(this.zzVH));
            }
            switch (this.zzVI) {
                case 0: {
                    jSONObject.put("windowType", (Object)"NONE");
                    break;
                }
                case 1: {
                    jSONObject.put("windowType", (Object)"NORMAL");
                    break;
                }
                case 2: {
                    jSONObject.put("windowType", (Object)"ROUNDED_CORNERS");
                    break;
                }
            }
            if (this.zzVJ != 0) {
                jSONObject.put("windowColor", (Object)this.zzH(this.zzVJ));
            }
            if (this.zzVI == 2) {
                jSONObject.put("windowRoundedCornerRadius", this.zzVK);
            }
            if (this.zzVL != null) {
                jSONObject.put("fontFamily", (Object)this.zzVL);
            }
            switch (this.zzVM) {
                case 0: {
                    jSONObject.put("fontGenericFamily", (Object)"SANS_SERIF");
                    break;
                }
                case 1: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SANS_SERIF");
                    break;
                }
                case 2: {
                    jSONObject.put("fontGenericFamily", (Object)"SERIF");
                    break;
                }
                case 3: {
                    jSONObject.put("fontGenericFamily", (Object)"MONOSPACED_SERIF");
                    break;
                }
                case 4: {
                    jSONObject.put("fontGenericFamily", (Object)"CASUAL");
                    break;
                }
                case 5: {
                    jSONObject.put("fontGenericFamily", (Object)"CURSIVE");
                    break;
                }
                case 6: {
                    jSONObject.put("fontGenericFamily", (Object)"SMALL_CAPITALS");
                    break;
                }
            }
            switch (this.zzVN) {
                case 0: {
                    jSONObject.put("fontStyle", (Object)"NORMAL");
                    break;
                }
                case 1: {
                    jSONObject.put("fontStyle", (Object)"BOLD");
                    break;
                }
                case 2: {
                    jSONObject.put("fontStyle", (Object)"ITALIC");
                    break;
                }
                case 3: {
                    jSONObject.put("fontStyle", (Object)"BOLD_ITALIC");
                    break;
                }
            }
            if (this.zzUl != null) {
                jSONObject.put("customData", (Object)this.zzUl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    private String zzH(int n) {
        return String.format("#%02X%02X%02X%02X", Color.red((int)n), Color.green((int)n), Color.blue((int)n), Color.alpha((int)n));
    }

    private int zzbH(String string) {
        if (string != null && string.length() == 9 && string.charAt(0) == '#') {
            try {
                int n = Integer.parseInt(string.substring(1, 3), 16);
                int n2 = Integer.parseInt(string.substring(3, 5), 16);
                int n3 = Integer.parseInt(string.substring(5, 7), 16);
                int n4 = Integer.parseInt(string.substring(7, 9), 16);
                return Color.argb((int)n4, (int)n, (int)n2, (int)n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextTrackStyle)) {
            return false;
        }
        TextTrackStyle textTrackStyle = (TextTrackStyle)other;
        if (this.zzUl == null != (textTrackStyle.zzUl == null)) {
            return false;
        }
        if (this.zzUl != null && textTrackStyle.zzUl != null && !zzls.zzd((Object)this.zzUl, (Object)textTrackStyle.zzUl)) {
            return false;
        }
        return this.zzVE == textTrackStyle.zzVE && this.zzVF == textTrackStyle.zzVF && this.zzvF == textTrackStyle.zzvF && this.zzVG == textTrackStyle.zzVG && this.zzVH == textTrackStyle.zzVH && this.zzVI == textTrackStyle.zzVI && this.zzVK == textTrackStyle.zzVK && zzf.zza(this.zzVL, textTrackStyle.zzVL) && this.zzVM == textTrackStyle.zzVM && this.zzVN == textTrackStyle.zzVN;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{Float.valueOf(this.zzVE), this.zzVF, this.zzvF, this.zzVG, this.zzVH, this.zzVI, this.zzVJ, this.zzVK, this.zzVL, this.zzVM, this.zzVN, this.zzUl});
    }
}

