/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzls;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MediaQueueItem {
    public static final int INVALID_ITEM_ID = 0;
    public static final double DEFAULT_PLAYBACK_DURATION = Double.POSITIVE_INFINITY;
    private MediaInfo zzUu;
    private int zzUv = 0;
    private boolean zzUw = true;
    private double zzUx;
    private double zzUy = Double.POSITIVE_INFINITY;
    private double zzUz;
    private long[] zzUA;
    private JSONObject zzUl;

    private MediaQueueItem(MediaInfo media) throws IllegalArgumentException {
        if (media == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzUu = media;
    }

    MediaQueueItem(JSONObject json) throws JSONException {
        this.zzg(json);
    }

    private MediaQueueItem(MediaQueueItem item) throws IllegalArgumentException {
        this.zzUu = item.getMedia();
        if (this.zzUu == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        this.zzUv = item.getItemId();
        this.zzUw = item.getAutoplay();
        this.zzUx = item.getStartTime();
        this.zzUy = item.zzmb();
        this.zzUz = item.getPreloadTime();
        this.zzUA = item.getActiveTrackIds();
        this.zzUl = item.getCustomData();
    }

    public boolean zzg(JSONObject jSONObject) throws JSONException {
        double d;
        double d2;
        double d3;
        int n;
        boolean bl = false;
        if (jSONObject.has("media")) {
            this.zzUu = new MediaInfo(jSONObject.getJSONObject("media"));
            bl = true;
        }
        if (jSONObject.has("itemId") && this.zzUv != (n = jSONObject.getInt("itemId"))) {
            this.zzUv = n;
            bl = true;
        }
        if (jSONObject.has("autoplay") && this.zzUw != (n = (int)(jSONObject.getBoolean("autoplay") ? 1 : 0))) {
            this.zzUw = n;
            bl = true;
        }
        if (jSONObject.has("startTime") && Math.abs((d3 = jSONObject.getDouble("startTime")) - this.zzUx) > 1.0E-7) {
            this.zzUx = d3;
            bl = true;
        }
        if (jSONObject.has("playbackDuration") && Math.abs((d2 = jSONObject.getDouble("playbackDuration")) - this.zzUy) > 1.0E-7) {
            this.zzUy = d2;
            bl = true;
        }
        if (jSONObject.has("preloadTime") && Math.abs((d = jSONObject.getDouble("preloadTime")) - this.zzUz) > 1.0E-7) {
            this.zzUz = d;
            bl = true;
        }
        boolean bl2 = false;
        long[] lArray = null;
        if (jSONObject.has("activeTrackIds")) {
            int n2;
            JSONArray jSONArray = jSONObject.getJSONArray("activeTrackIds");
            int n3 = jSONArray.length();
            lArray = new long[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                lArray[n2] = jSONArray.getLong(n2);
            }
            if (this.zzUA == null) {
                bl2 = true;
            } else if (this.zzUA.length != n3) {
                bl2 = true;
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    if (this.zzUA[n2] == lArray[n2]) continue;
                    bl2 = true;
                    break;
                }
            }
        }
        if (bl2) {
            this.zzUA = lArray;
            bl = true;
        }
        if (jSONObject.has("customData")) {
            this.zzUl = jSONObject.getJSONObject("customData");
            bl = true;
        }
        return bl;
    }

    public MediaInfo getMedia() {
        return this.zzUu;
    }

    public int getItemId() {
        return this.zzUv;
    }

    void zzaK(int n) {
        this.zzUv = n;
    }

    public boolean getAutoplay() {
        return this.zzUw;
    }

    void zzT(boolean bl) {
        this.zzUw = bl;
    }

    public double getStartTime() {
        return this.zzUx;
    }

    void zzc(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        this.zzUx = d;
    }

    public double zzmb() {
        return this.zzUy;
    }

    public double getPreloadTime() {
        return this.zzUz;
    }

    void zzd(double d) throws IllegalArgumentException {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or NaN.");
        }
        this.zzUz = d;
    }

    public long[] getActiveTrackIds() {
        return this.zzUA;
    }

    void zza(long[] lArray) {
        this.zzUA = lArray;
    }

    public JSONObject getCustomData() {
        return this.zzUl;
    }

    void setCustomData(JSONObject customData) {
        this.zzUl = customData;
    }

    void zzma() throws IllegalArgumentException {
        if (this.zzUu == null) {
            throw new IllegalArgumentException("media cannot be null.");
        }
        if (Double.isNaN(this.zzUx) || this.zzUx < 0.0) {
            throw new IllegalArgumentException("startTime cannot be negative or NaN.");
        }
        if (Double.isNaN(this.zzUy)) {
            throw new IllegalArgumentException("playbackDuration cannot be NaN.");
        }
        if (Double.isNaN(this.zzUz) || this.zzUz < 0.0) {
            throw new IllegalArgumentException("preloadTime cannot be negative or Nan.");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("media", (Object)this.zzUu.toJson());
            if (this.zzUv != 0) {
                jSONObject.put("itemId", this.zzUv);
            }
            jSONObject.put("autoplay", this.zzUw);
            jSONObject.put("startTime", this.zzUx);
            if (this.zzUy != Double.POSITIVE_INFINITY) {
                jSONObject.put("playbackDuration", this.zzUy);
            }
            jSONObject.put("preloadTime", this.zzUz);
            if (this.zzUA != null && this.zzUA.length > 0) {
                JSONArray jSONArray = new JSONArray();
                for (long l : this.zzUA) {
                    jSONArray.put(l);
                }
                jSONObject.put("activeTrackIds", (Object)jSONArray);
            }
            if (this.zzUl != null) {
                jSONObject.put("customData", (Object)this.zzUl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaQueueItem)) {
            return false;
        }
        MediaQueueItem mediaQueueItem = (MediaQueueItem)other;
        if (this.zzUl == null != (mediaQueueItem.zzUl == null)) {
            return false;
        }
        if (this.zzUl != null && mediaQueueItem.zzUl != null && !zzls.zzd((Object)this.zzUl, (Object)mediaQueueItem.zzUl)) {
            return false;
        }
        return zzf.zza(this.zzUu, mediaQueueItem.zzUu) && this.zzUv == mediaQueueItem.zzUv && this.zzUw == mediaQueueItem.zzUw && this.zzUx == mediaQueueItem.zzUx && this.zzUy == mediaQueueItem.zzUy && this.zzUz == mediaQueueItem.zzUz && zzf.zza(this.zzUA, mediaQueueItem.zzUA);
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUu, this.zzUv, this.zzUw, this.zzUx, this.zzUy, this.zzUz, this.zzUA, String.valueOf(this.zzUl)});
    }

    public static class Builder {
        private final MediaQueueItem zzUB;

        public Builder(MediaInfo media) throws IllegalArgumentException {
            this.zzUB = new MediaQueueItem(media);
        }

        public Builder(JSONObject json) throws JSONException {
            this.zzUB = new MediaQueueItem(json);
        }

        public Builder(MediaQueueItem item) throws IllegalArgumentException {
            this.zzUB = new MediaQueueItem(item);
        }

        public Builder clearItemId() {
            this.zzUB.zzaK(0);
            return this;
        }

        public Builder setAutoplay(boolean autoplay) {
            this.zzUB.zzT(autoplay);
            return this;
        }

        public Builder setStartTime(double startTime) throws IllegalArgumentException {
            this.zzUB.zzc(startTime);
            return this;
        }

        public Builder setPreloadTime(double preloadTime) throws IllegalArgumentException {
            this.zzUB.zzd(preloadTime);
            return this;
        }

        public Builder setActiveTrackIds(long[] activeTrackIds) {
            this.zzUB.zza(activeTrackIds);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzUB.setCustomData(customData);
            return this;
        }

        public MediaQueueItem build() {
            this.zzUB.zzma();
            return this.zzUB;
        }
    }
}

