/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.cast.MediaTrack;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.cast.internal.zzf;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.internal.zzls;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    public static final long UNKNOWN_DURATION = -1L;
    private final String zzUe;
    private int zzUf;
    private String zzUg;
    private MediaMetadata zzUh;
    private long zzUi;
    private List<MediaTrack> zzUj;
    private TextTrackStyle zzUk;
    private JSONObject zzUl;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.zzUe = contentId;
        this.zzUf = -1;
        this.zzUi = -1L;
    }

    MediaInfo(JSONObject json) throws JSONException {
        double d;
        int n;
        JSONObject jSONObject;
        this.zzUe = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.zzUf = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.zzUg = json.getString("contentType");
        if (json.has("metadata")) {
            jSONObject = json.getJSONObject("metadata");
            n = jSONObject.getInt("metadataType");
            this.zzUh = new MediaMetadata(n);
            this.zzUh.zzf(jSONObject);
        }
        this.zzUi = -1L;
        if (json.has("duration") && !json.isNull("duration") && !Double.isNaN(d = json.optDouble("duration", 0.0)) && !Double.isInfinite(d)) {
            this.zzUi = zzf.zzf(d);
        }
        if (json.has("tracks")) {
            this.zzUj = new ArrayList<MediaTrack>();
            jSONObject = json.getJSONArray("tracks");
            for (n = 0; n < jSONObject.length(); ++n) {
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                MediaTrack mediaTrack = new MediaTrack(jSONObject2);
                this.zzUj.add(mediaTrack);
            }
        } else {
            this.zzUj = null;
        }
        if (json.has("textTrackStyle")) {
            jSONObject = json.getJSONObject("textTrackStyle");
            TextTrackStyle textTrackStyle = new TextTrackStyle();
            textTrackStyle.zzf(jSONObject);
            this.zzUk = textTrackStyle;
        } else {
            this.zzUk = null;
        }
        this.zzUl = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.zzUe;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.zzUf = streamType;
    }

    public int getStreamType() {
        return this.zzUf;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.zzUg = contentType;
    }

    public String getContentType() {
        return this.zzUg;
    }

    void zza(MediaMetadata mediaMetadata) {
        this.zzUh = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.zzUh;
    }

    void zzx(long l) throws IllegalArgumentException {
        if (l < 0L && l != -1L) {
            throw new IllegalArgumentException("Invalid stream duration");
        }
        this.zzUi = l;
    }

    public long getStreamDuration() {
        return this.zzUi;
    }

    void zzj(List<MediaTrack> list) {
        this.zzUj = list;
    }

    public List<MediaTrack> getMediaTracks() {
        return this.zzUj;
    }

    public void setTextTrackStyle(TextTrackStyle textTrackStyle) {
        this.zzUk = textTrackStyle;
    }

    public TextTrackStyle getTextTrackStyle() {
        return this.zzUk;
    }

    void setCustomData(JSONObject customData) {
        this.zzUl = customData;
    }

    public JSONObject getCustomData() {
        return this.zzUl;
    }

    void zzma() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.zzUe)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.zzUg)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.zzUf == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.zzUe);
            switch (this.zzUf) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.zzUg != null) {
                jSONObject.put("contentType", (Object)this.zzUg);
            }
            if (this.zzUh != null) {
                jSONObject.put("metadata", (Object)this.zzUh.toJson());
            }
            if (this.zzUi <= -1L) {
                jSONObject.put("duration", JSONObject.NULL);
            } else {
                jSONObject.put("duration", zzf.zzA(this.zzUi));
            }
            if (this.zzUj != null) {
                JSONArray jSONArray = new JSONArray();
                for (MediaTrack mediaTrack : this.zzUj) {
                    jSONArray.put((Object)mediaTrack.toJson());
                }
                jSONObject.put("tracks", (Object)jSONArray);
            }
            if (this.zzUk != null) {
                jSONObject.put("textTrackStyle", (Object)this.zzUk.toJson());
            }
            if (this.zzUl != null) {
                jSONObject.put("customData", (Object)this.zzUl);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.zzUl == null != (mediaInfo.zzUl == null)) {
            return false;
        }
        if (this.zzUl != null && mediaInfo.zzUl != null && !zzls.zzd((Object)this.zzUl, (Object)mediaInfo.zzUl)) {
            return false;
        }
        return zzf.zza(this.zzUe, mediaInfo.zzUe) && this.zzUf == mediaInfo.zzUf && zzf.zza(this.zzUg, mediaInfo.zzUg) && zzf.zza(this.zzUh, mediaInfo.zzUh) && this.zzUi == mediaInfo.zzUi;
    }

    public int hashCode() {
        return zzw.hashCode((Object[])new Object[]{this.zzUe, this.zzUf, this.zzUg, this.zzUh, this.zzUi, String.valueOf(this.zzUl)});
    }

    public static class Builder {
        private final MediaInfo zzUm;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.zzUm = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.zzUm.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.zzUm.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.zzUm.zza(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.zzUm.zzx(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.zzUm.setCustomData(customData);
            return this;
        }

        public Builder setMediaTracks(List<MediaTrack> mediaTracks) {
            this.zzUm.zzj(mediaTracks);
            return this;
        }

        public Builder setTextTrackStyle(TextTrackStyle textTrackStyle) {
            this.zzUm.setTextTrackStyle(textTrackStyle);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.zzUm.zzma();
            return this.zzUm;
        }
    }
}

