/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.zzf;

public final class MarkerOptions
implements SafeParcelable {
    public static final zzf CREATOR = new zzf();
    private final int mVersionCode;
    private LatLng zzaGx;
    private String zzagU;
    private String zzaHr;
    private BitmapDescriptor zzaHs;
    private float zzaHi = 0.5f;
    private float zzaHj = 1.0f;
    private boolean zzaHt;
    private boolean zzaHa = true;
    private boolean zzaHu = false;
    private float zzaHv = 0.0f;
    private float zzaHw = 0.5f;
    private float zzaHx = 0.0f;
    private float mAlpha = 1.0f;

    public MarkerOptions() {
        this.mVersionCode = 1;
    }

    MarkerOptions(int versionCode, LatLng position, String title, String snippet, IBinder wrappedIcon, float anchorU, float anchorV, boolean draggable, boolean visible, boolean flat, float rotation, float infoWindowAnchorU, float infoWindowAnchorV, float alpha) {
        this.mVersionCode = versionCode;
        this.zzaGx = position;
        this.zzagU = title;
        this.zzaHr = snippet;
        this.zzaHs = wrappedIcon == null ? null : new BitmapDescriptor(zzd.zza.zzbk((IBinder)wrappedIcon));
        this.zzaHi = anchorU;
        this.zzaHj = anchorV;
        this.zzaHt = draggable;
        this.zzaHa = visible;
        this.zzaHu = flat;
        this.zzaHv = rotation;
        this.zzaHw = infoWindowAnchorU;
        this.zzaHx = infoWindowAnchorV;
        this.mAlpha = alpha;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzf.zza(this, out, flags);
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    IBinder zzxd() {
        return this.zzaHs == null ? null : this.zzaHs.zzwB().asBinder();
    }

    public MarkerOptions position(LatLng position) {
        this.zzaGx = position;
        return this;
    }

    public MarkerOptions icon(BitmapDescriptor icon) {
        this.zzaHs = icon;
        return this;
    }

    public MarkerOptions anchor(float u, float v) {
        this.zzaHi = u;
        this.zzaHj = v;
        return this;
    }

    public MarkerOptions infoWindowAnchor(float u, float v) {
        this.zzaHw = u;
        this.zzaHx = v;
        return this;
    }

    public MarkerOptions title(String title) {
        this.zzagU = title;
        return this;
    }

    public MarkerOptions snippet(String snippet) {
        this.zzaHr = snippet;
        return this;
    }

    public MarkerOptions draggable(boolean draggable) {
        this.zzaHt = draggable;
        return this;
    }

    public MarkerOptions visible(boolean visible) {
        this.zzaHa = visible;
        return this;
    }

    public MarkerOptions flat(boolean flat) {
        this.zzaHu = flat;
        return this;
    }

    public MarkerOptions rotation(float rotation) {
        this.zzaHv = rotation;
        return this;
    }

    public MarkerOptions alpha(float alpha) {
        this.mAlpha = alpha;
        return this;
    }

    public LatLng getPosition() {
        return this.zzaGx;
    }

    public String getTitle() {
        return this.zzagU;
    }

    public String getSnippet() {
        return this.zzaHr;
    }

    public BitmapDescriptor getIcon() {
        return this.zzaHs;
    }

    public float getAnchorU() {
        return this.zzaHi;
    }

    public float getAnchorV() {
        return this.zzaHj;
    }

    public boolean isDraggable() {
        return this.zzaHt;
    }

    public boolean isVisible() {
        return this.zzaHa;
    }

    public boolean isFlat() {
        return this.zzaHu;
    }

    public float getRotation() {
        return this.zzaHv;
    }

    public float getInfoWindowAnchorU() {
        return this.zzaHw;
    }

    public float getInfoWindowAnchorV() {
        return this.zzaHx;
    }

    public float getAlpha() {
        return this.mAlpha;
    }
}

